/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets;

import com.github.x3r.mekanism_turrets.MekanismTurretsConfig;
import com.github.x3r.mekanism_turrets.common.block_entity.ElectricFenceBlockEntity;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretTier;
import com.github.x3r.mekanism_turrets.common.entity.LaserEntity;
import com.github.x3r.mekanism_turrets.common.packet.MekanismTurretsPacketHandler;
import com.github.x3r.mekanism_turrets.common.registry.BlockEntityTypeRegistry;
import com.github.x3r.mekanism_turrets.common.registry.BlockRegistry;
import com.github.x3r.mekanism_turrets.common.registry.ContainerTypeRegistry;
import com.github.x3r.mekanism_turrets.common.registry.EntityRegistry;
import com.github.x3r.mekanism_turrets.common.registry.ItemRegistry;
import com.github.x3r.mekanism_turrets.common.registry.SoundRegistry;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod(value="mekanism_turrets")
public class MekanismTurrets {
    public static final String MOD_ID = "mekanism_turrets";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MekanismTurrets(IEventBus modEventBus, Dist dist, ModContainer container) {
        IEventBus neoEventBus = NeoForge.EVENT_BUS;
        BlockRegistry.BLOCKS.register(modEventBus);
        BlockEntityTypeRegistry.BLOCK_ENTITY_TYPES.register(modEventBus);
        ContainerTypeRegistry.CONTAINER_TYPES.register(modEventBus);
        EntityRegistry.ENTITY_TYPES.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ItemRegistry.ModItemTab.CREATIVE_MODE_TABS.register(modEventBus);
        SoundRegistry.SOUNDS.register(modEventBus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MekanismTurretsConfig.SPEC);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::loadConfig);
        modEventBus.addListener(MekanismTurretsPacketHandler::registerPayloadHandler);
        neoEventBus.addListener(LaserEntity::enterChunk);
        this.registerDataTickets();
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, blockEntity, context) -> ((ElectricFenceBlockEntity)blockEntity).energyStorage, new Block[]{(Block)BlockRegistry.ELECTRIC_FENCE.get()});
    }

    @SubscribeEvent
    public void loadConfig(ModConfigEvent.Loading event) {
        LaserTurretTier.BASIC.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.basicLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.basicLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.basicLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.basicLaserTurretRange);
        LaserTurretTier.ADVANCED.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.advancedLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.advancedLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.advancedLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.advancedLaserTurretRange);
        LaserTurretTier.ELITE.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.eliteLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.eliteLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.eliteLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.eliteLaserTurretRange);
        LaserTurretTier.ULTIMATE.setConfigReference((Supplier<Integer>)MekanismTurretsConfig.ultimateLaserTurretCooldown, (Supplier<Double>)MekanismTurretsConfig.ultimateLaserTurretDamage, (Supplier<Integer>)MekanismTurretsConfig.ultimateLaserTurretEnergyCapacity, (Supplier<Double>)MekanismTurretsConfig.ultimateLaserTurretRange);
    }

    private void registerDataTickets() {
        LaserTurretBlockEntity.HAS_TARGET = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofBoolean((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"has_target")));
        LaserTurretBlockEntity.TARGET_POS_X = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofDouble((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"target_pos_x")));
        LaserTurretBlockEntity.TARGET_POS_Y = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofDouble((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"target_pos_y")));
        LaserTurretBlockEntity.TARGET_POS_Z = GeckoLibUtil.addDataTicket((SerializableDataTicket)SerializableDataTicket.ofDouble((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"target_pos_z")));
    }
}

