/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.client.renderer;

import com.github.x3r.mekanism_turrets.common.entity.LaserEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class LaserRenderer<T extends LaserEntity>
extends EntityRenderer<T> {
    public static final ResourceLocation LASER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/entity/laser.png");

    public LaserRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        int i;
        this.fixRotation(pEntity);
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)((LaserEntity)((Object)pEntity)).yRotO, (float)pEntity.getYRot()) - 90.0f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)((LaserEntity)((Object)pEntity)).xRotO, (float)pEntity.getXRot())));
        pPoseStack.scale(0.05625f, 0.05625f, 0.05625f);
        pPoseStack.translate(0.0f, 2.5f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.eyes((ResourceLocation)this.getTextureLocation((LaserEntity)((Object)pEntity))));
        PoseStack.Pose pose = pPoseStack.last();
        for (i = 0; i < 4; ++i) {
            this.longFace(pose, vertexconsumer, pPackedLight);
            pPoseStack.translate(0.0f, 2.0f, -2.0f);
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        pPoseStack.translate(-8.0f, 0.0f, -2.0f);
        for (i = 0; i < 2; ++i) {
            this.shortFace(pose, vertexconsumer, pPackedLight);
            pPoseStack.translate(16.0f, 0.0f, 0.0f);
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
        pPoseStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    private void shortFace(PoseStack.Pose pose, VertexConsumer vertexconsumer, int pPackedLight) {
        this.vertex(pose, vertexconsumer, 0, -2, -2, 0.0f, 0.0f, 0, -1, 0, pPackedLight);
        this.vertex(pose, vertexconsumer, 0, -2, 2, 0.125f, 0.0f, 0, -1, 0, pPackedLight);
        this.vertex(pose, vertexconsumer, 0, 2, 2, 0.125f, 0.125f, 0, -1, 0, pPackedLight);
        this.vertex(pose, vertexconsumer, 0, 2, -2, 0.0f, 0.125f, 0, -1, 0, pPackedLight);
    }

    private void longFace(PoseStack.Pose pose, VertexConsumer vertexconsumer, int pPackedLight) {
        this.vertex(pose, vertexconsumer, -8, 0, -2, 0.0f, 0.0f, 0, -1, 0, pPackedLight);
        this.vertex(pose, vertexconsumer, 8, 0, -2, 0.375f, 0.0f, 0, -1, 0, pPackedLight);
        this.vertex(pose, vertexconsumer, 8, 0, 2, 0.375f, 0.125f, 0, -1, 0, pPackedLight);
        this.vertex(pose, vertexconsumer, -8, 0, 2, 0.0f, 0.125f, 0, -1, 0, pPackedLight);
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer pConsumer, int pX, int pY, int pZ, float pU, float pV, int pNormalX, int pNormalZ, int pNormalY, int pPackedLight) {
        pConsumer.addVertex(pose, (float)pX, (float)pY, (float)pZ).setColor(255, 255, 255, 255).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pPackedLight).setNormal(pose, (float)pNormalX, (float)pNormalY, (float)pNormalZ);
    }

    private void fixRotation(T entity) {
        Vec3 vec = entity.getDeltaMovement();
        entity.setYRot((float)Math.atan2(vec.x, vec.z) * 57.295776f);
        entity.setXRot((float)Math.atan2(vec.y, Math.sqrt(vec.x * vec.x + vec.z * vec.z)) * 57.295776f);
    }

    public ResourceLocation getTextureLocation(LaserEntity pEntity) {
        return LASER_TEXTURE;
    }
}

