/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.block;

import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import java.util.stream.Stream;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserTurretBlock
extends BlockTile.BlockTileModel<LaserTurretBlockEntity, BlockTypeTile<LaserTurretBlockEntity>> {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static VoxelShape SHAPE_NORTH;
    private static VoxelShape SHAPE_EAST;
    private static VoxelShape SHAPE_SOUTH;
    private static VoxelShape SHAPE_WEST;
    private static VoxelShape SHAPE_UP;
    private static VoxelShape SHAPE_DOWN;

    public LaserTurretBlock(BlockTypeTile<LaserTurretBlockEntity> type) {
        super(type, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        LaserTurretBlockEntity tile = (LaserTurretBlockEntity)WorldUtils.getTileEntity(LaserTurretBlockEntity.class, (BlockGetter)world, (BlockPos)pos, (boolean)true);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return tile.openGui(player);
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos pos) {
        LaserTurretBlockEntity tile = (LaserTurretBlockEntity)WorldUtils.getTileEntity(LaserTurretBlockEntity.class, (BlockGetter)world, (BlockPos)pos, (boolean)true);
        return tile.hasTarget() ? 15 : 0;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                if (SHAPE_NORTH == null) {
                    SHAPE_NORTH = Stream.of(Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0), Block.box((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)2.0), Block.box((double)12.0, (double)12.0, (double)1.0, (double)13.0, (double)13.0, (double)2.0), Block.box((double)12.0, (double)3.0, (double)1.0, (double)13.0, (double)4.0, (double)2.0), Block.box((double)3.0, (double)3.0, (double)1.0, (double)4.0, (double)4.0, (double)2.0), Block.box((double)3.0, (double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
                }
                return SHAPE_NORTH;
            }
            case EAST: {
                if (SHAPE_EAST == null) {
                    SHAPE_EAST = Stream.of(Block.box((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.box((double)14.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), Block.box((double)14.0, (double)12.0, (double)12.0, (double)15.0, (double)13.0, (double)13.0), Block.box((double)14.0, (double)3.0, (double)12.0, (double)15.0, (double)4.0, (double)13.0), Block.box((double)14.0, (double)3.0, (double)3.0, (double)15.0, (double)4.0, (double)4.0), Block.box((double)14.0, (double)12.0, (double)3.0, (double)15.0, (double)13.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
                }
                return SHAPE_EAST;
            }
            case SOUTH: {
                if (SHAPE_SOUTH == null) {
                    SHAPE_SOUTH = Stream.of(Block.box((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0), Block.box((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)3.0, (double)12.0, (double)14.0, (double)4.0, (double)13.0, (double)15.0), Block.box((double)3.0, (double)3.0, (double)14.0, (double)4.0, (double)4.0, (double)15.0), Block.box((double)12.0, (double)3.0, (double)14.0, (double)13.0, (double)4.0, (double)15.0), Block.box((double)12.0, (double)12.0, (double)14.0, (double)13.0, (double)13.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
                }
                return SHAPE_SOUTH;
            }
            case WEST: {
                if (SHAPE_WEST == null) {
                    SHAPE_WEST = Stream.of(Block.box((double)0.0, (double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0), Block.box((double)1.0, (double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0), Block.box((double)1.0, (double)12.0, (double)3.0, (double)2.0, (double)13.0, (double)4.0), Block.box((double)1.0, (double)3.0, (double)3.0, (double)2.0, (double)4.0, (double)4.0), Block.box((double)1.0, (double)3.0, (double)12.0, (double)2.0, (double)4.0, (double)13.0), Block.box((double)1.0, (double)12.0, (double)12.0, (double)2.0, (double)13.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
                }
                return SHAPE_WEST;
            }
            case UP: {
                if (SHAPE_UP == null) {
                    SHAPE_UP = Stream.of(Block.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), Block.box((double)12.0, (double)14.0, (double)3.0, (double)13.0, (double)15.0, (double)4.0), Block.box((double)3.0, (double)14.0, (double)3.0, (double)4.0, (double)15.0, (double)4.0), Block.box((double)3.0, (double)14.0, (double)12.0, (double)4.0, (double)15.0, (double)13.0), Block.box((double)12.0, (double)14.0, (double)12.0, (double)13.0, (double)15.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
                }
                return SHAPE_UP;
            }
            case DOWN: {
                if (SHAPE_DOWN == null) {
                    SHAPE_DOWN = Stream.of(Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)12.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)4.0), Block.box((double)12.0, (double)1.0, (double)12.0, (double)13.0, (double)2.0, (double)13.0), Block.box((double)3.0, (double)1.0, (double)12.0, (double)4.0, (double)2.0, (double)13.0), Block.box((double)3.0, (double)1.0, (double)3.0, (double)4.0, (double)2.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
                }
                return SHAPE_DOWN;
            }
        }
        return Shapes.block();
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.block();
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return super.getVisualShape(state, level, pos, context);
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.create((AABB)AABB.ofSize((Vec3)pPos.getCenter(), (double)2.0, (double)2.0, (double)2.0));
    }
}

