/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.packet;

import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ModifyTurretTargetPayload(BlockPos blockEntityPos, byte index, boolean value) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ModifyTurretTargetPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"modify_turret_target"));
    public static final StreamCodec<ByteBuf, ModifyTurretTargetPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ModifyTurretTargetPayload::blockEntityPos, (StreamCodec)ByteBufCodecs.BYTE, ModifyTurretTargetPayload::index, (StreamCodec)ByteBufCodecs.BOOL, ModifyTurretTargetPayload::value, ModifyTurretTargetPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleServer(ModifyTurretTargetPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            BlockEntity be = player.level().getBlockEntity(payload.blockEntityPos);
            if (be instanceof LaserTurretBlockEntity) {
                LaserTurretBlockEntity turret = (LaserTurretBlockEntity)be;
                switch (payload.index) {
                    case 0: {
                        turret.setTargetsHostile(payload.value);
                        break;
                    }
                    case 1: {
                        turret.setTargetsPassive(payload.value);
                        break;
                    }
                    case 2: {
                        turret.setTargetsPlayers(payload.value);
                        break;
                    }
                    case 3: {
                        turret.setTargetsTrusted(payload.value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid index: " + payload.index);
                    }
                }
                turret.markUpdated();
                turret.tryInvalidateTarget();
            }
        });
    }
}

