/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.su5ed.mffs.item.CustomProjectorModeItem;
import dev.su5ed.mffs.network.StructureDataRequestPacket;
import dev.su5ed.mffs.render.BlockHighlighter;
import dev.su5ed.mffs.setup.ModDataComponentTypes;
import dev.su5ed.mffs.setup.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import one.util.streamex.StreamEx;

@EventBusSubscriber(modid="mffs", value={Dist.CLIENT})
public final class CustomProjectorModeClientHandler {
    private static final float MIN_ALPHA = 0.1f;
    private static final float MAX_ALPHA = BlockHighlighter.LIGHT_RED.alpha();
    private static final int PERIOD_TICKS = 30;
    private static final Map<ResourceKey<Level>, Map<String, VoxelShape>> STRUCTURE_SHAPES = new HashMap<ResourceKey<Level>, Map<String, VoxelShape>>();

    public static VoxelShape getOrRequestShape(ItemStack stack, Level level) {
        String id = (String)stack.get(ModDataComponentTypes.PATTERN_ID);
        if (id == null) {
            return null;
        }
        ResourceKey key = level.dimension();
        Map<String, VoxelShape> map = STRUCTURE_SHAPES.get(key);
        if (map == null || !map.containsKey(id)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new StructureDataRequestPacket(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CustomProjectorModeClientHandler.setShape((ResourceKey<Level>)key, id, null);
            return null;
        }
        return map.get(id);
    }

    public static void setShape(ResourceKey<Level> level, String id, VoxelShape shape) {
        Map map = STRUCTURE_SHAPES.computeIfAbsent(level, l -> new HashMap());
        map.put(id, shape);
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            Minecraft minecraft = Minecraft.getInstance();
            StreamEx.of((Object[])new ItemStack[]{minecraft.player.getMainHandItem(), minecraft.player.getOffhandItem()}).findFirst(stack -> stack.is((Item)ModItems.CUSTOM_MODE.get())).ifPresent(stack -> {
                VoxelShape shape;
                BlockPos primary;
                PoseStack pose = new PoseStack();
                Vec3 cameraPos = event.getCamera().getPosition();
                CustomProjectorModeItem.StructureCoords coords = (CustomProjectorModeItem.StructureCoords)stack.get(ModDataComponentTypes.STRUCTURE_COORDS);
                if (coords != null && (primary = coords.primary()) != null) {
                    BlockHighlighter.highlightBlock(pose, cameraPos, primary, BlockHighlighter.LIGHT_GREEN);
                    if (coords.secondary() != null) {
                        BlockPos secondary = coords.secondary();
                        BlockHighlighter.highlightBlock(pose, cameraPos, secondary, BlockHighlighter.LIGHT_RED);
                        BlockHighlighter.highlightArea(pose, cameraPos, primary, secondary);
                    } else {
                        HitResult patt0$temp = minecraft.hitResult;
                        if (patt0$temp instanceof BlockHitResult) {
                            BlockHitResult blockHitResult = (BlockHitResult)patt0$temp;
                            BlockPos secondary = blockHitResult.getBlockPos();
                            float alpha = 0.1f + (MAX_ALPHA - 0.1f) * 0.5f * Mth.abs((float)(Mth.sin((float)(0.20943953f * (float)event.getRenderTick())) + 1.0f));
                            BlockHighlighter.highlightBlock(pose, cameraPos, secondary, BlockHighlighter.LIGHT_RED.withAlpha(alpha));
                            BlockHighlighter.highlightArea(pose, cameraPos, primary, secondary);
                        }
                    }
                }
                if (stack.has(ModDataComponentTypes.PATTERN_ID) && (shape = CustomProjectorModeClientHandler.getOrRequestShape(stack, (Level)minecraft.level)) != null) {
                    BlockHighlighter.highlightArea(pose, cameraPos, shape, null);
                }
            });
        }
    }

    private CustomProjectorModeClientHandler() {
    }
}

