/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.item.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public final class BlockOverlayingItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ModelResourceLocation itemModelLocation;
    private final Function<ItemStack, Optional<Block>> blockFromItemStackGetter;

    public BlockOverlayingItemRenderer(ModelResourceLocation itemModelLocation, Function<ItemStack, Optional<Block>> blockFromItemStackGetter) {
        super(null, null);
        this.itemModelLocation = itemModelLocation;
        this.blockFromItemStackGetter = blockFromItemStackGetter;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Optional<Block> blockOptional;
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        BakedModel model = renderer.getItemModelShaper().getModelManager().getModel(this.itemModelLocation);
        renderer.render(stack, displayContext, BlockOverlayingItemRenderer.isLeftHand(displayContext), poseStack, buffer, packedLight, packedOverlay, model);
        if (displayContext == ItemDisplayContext.GUI && (blockOptional = this.blockFromItemStackGetter.apply(stack)).isPresent()) {
            poseStack.pushPose();
            poseStack.popPose();
            poseStack.translate(0.0, -0.37, 0.0);
            poseStack.scale(0.4f, 0.4f, 0.4f);
            poseStack.rotateAround(Axis.XP.rotationDegrees(30.0f), 0.5f, 0.5f, 0.5f);
            poseStack.rotateAround(Axis.YP.rotationDegrees(225.0f), 0.5f, 0.5f, 0.5f);
            BlockState blockState = blockOptional.get().defaultBlockState();
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            blockRenderer.renderSingleBlock(blockState, poseStack, buffer, packedLight, packedOverlay, ModelData.EMPTY, null);
        }
        poseStack.popPose();
    }

    private static boolean isLeftHand(ItemDisplayContext context) {
        return context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || context == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }
}

