/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered;

import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered.CustomMultiblockTier;
import net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered.TieredCraftingMultiblockBlockEntity;

public final class ElectricTieredCraftingMultiblockBlockEntity
extends TieredCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    private final RedstoneControlComponent redstoneControl;
    private final UpgradeComponent upgrades;
    private final OverdriveComponent overdrive;
    private final List<EnergyComponent> energyInputs = Lists.newArrayList();

    public ElectricTieredCraftingMultiblockBlockEntity(BEP bep, ResourceLocation name, CustomMultiblockTier[] tiers, long maxRecipeEu) {
        super(bep, name, tiers, maxRecipeEu);
        this.redstoneControl = new RedstoneControlComponent();
        this.upgrades = new UpgradeComponent();
        this.overdrive = new OverdriveComponent();
        this.registerComponents(new MachineComponent[]{this.redstoneControl, this.upgrades, this.overdrive});
        this.registerGuiComponent(new GuiComponentServer[]{new SlotPanel((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withOverdrive(this.overdrive)});
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new CraftingMultiblockGui(() -> this.shapeValid.shapeValid, () -> ((CrafterComponent)this.crafter).getProgress(), this.crafter, () -> 0);
        this.registerGuiComponent(guiComponentServerArray);
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        if (shapeMatcher.isMatchSuccessful()) {
            this.energyInputs.clear();
            for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
                hatch.appendEnergyInputs(this.energyInputs);
            }
        }
    }

    public long consumeEu(long max, Simulation simulation) {
        long total = 0L;
        for (EnergyComponent energyComponent : this.energyInputs) {
            total += energyComponent.consumeEu(max - total, simulation);
        }
        return total;
    }

    public long getBaseRecipeEu() {
        return MachineTier.MULTIBLOCK.getBaseEu();
    }

    public List<? extends EnergyAccess> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    public long getMaxRecipeEu() {
        return super.getMaxRecipeEu() + this.upgrades.getAddMaxEUPerTick();
    }

    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }

    public boolean isOverdriving() {
        return this.overdrive.shouldOverdrive();
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = LubricantHelper.onUse((CrafterComponent)this.crafter, (Player)player, (InteractionHand)hand);
        }
        if (!result.consumesAction()) {
            result = (ItemInteractionResult)this.components.mapOrDefault(UpgradeComponent.class, c -> c.onUse((MachineBlockEntity)this, player, hand), (Object)result);
        }
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = (ItemInteractionResult)this.components.mapOrDefault(OverdriveComponent.class, c -> c.onUse((MachineBlockEntity)this, player, hand), (Object)result);
        }
        return result;
    }
}

