/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.swedz.mi_tweaks.machine.blockentity.multiblock.tiered.CustomMultiblockTier;
import net.swedz.tesseract.neoforge.compat.mi.helper.CommonGuiComponents;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.BasicMultiblockMachineBlockEntity;

public abstract class TieredCraftingMultiblockBlockEntity
extends BasicMultiblockMachineBlockEntity
implements CrafterComponent.Behavior {
    protected final CustomMultiblockTier[] tiers;
    protected final long maxRecipeEu;
    protected final CrafterComponent crafter;
    private OperatingState operatingState = OperatingState.NOT_MATCHED;

    public TieredCraftingMultiblockBlockEntity(BEP bep, ResourceLocation name, CustomMultiblockTier[] tiers, long maxRecipeEu) {
        super(bep, new MachineGuiParameters.Builder(name, false).backgroundHeight(200).build(), (ShapeTemplate[])Arrays.stream(tiers).map(CustomMultiblockTier::shape).toArray(ShapeTemplate[]::new));
        this.tiers = tiers;
        this.maxRecipeEu = maxRecipeEu;
        this.crafter = new CrafterComponent((MachineBlockEntity)this, (CrafterComponent.Inventory)this.inventory, (CrafterComponent.Behavior)this);
        this.registerComponents(new MachineComponent[]{this.crafter});
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[1];
        guiComponentServerArray[0] = new ReiSlotLocking((arg_0, arg_1) -> ((CrafterComponent)this.crafter).lockRecipe(arg_0, arg_1), () -> this.operatingState != OperatingState.NOT_MATCHED);
        this.registerGuiComponent(guiComponentServerArray);
        List<Component> tierTranslations = Arrays.stream(tiers).map(CustomMultiblockTier::getDisplayName).toList();
        this.registerGuiComponent(new GuiComponentServer[]{CommonGuiComponents.rangedShapeSelection((MultiblockMachineBlockEntity)this, (ActiveShapeComponent)this.activeShape, tierTranslations, (boolean)true)});
    }

    public CustomMultiblockTier getActiveTier() {
        return this.tiers[this.activeShape.getActiveShapeIndex()];
    }

    public MachineRecipeType recipeType() {
        return this.getActiveTier().recipeType();
    }

    public long getMaxRecipeEu() {
        return this.maxRecipeEu;
    }

    public boolean banRecipe(MachineRecipe recipe) {
        return super.banRecipe(recipe) || (long)recipe.eu > this.getActiveTier().maxBaseEu();
    }

    public ServerLevel getCrafterWorld() {
        return (ServerLevel)this.level;
    }

    public UUID getOwnerUuid() {
        return this.placedBy.placerId;
    }

    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        this.operatingState = OperatingState.NOT_MATCHED;
        if (shapeMatcher.isMatchSuccessful()) {
            this.operatingState = OperatingState.TRYING_TO_RESUME;
        }
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide()) {
            boolean newActive = false;
            if (this.operatingState == OperatingState.TRYING_TO_RESUME && this.crafter.tryContinueRecipe()) {
                this.operatingState = OperatingState.NORMAL_OPERATION;
            }
            if (this.operatingState == OperatingState.NORMAL_OPERATION) {
                if (this.crafter.tickRecipe()) {
                    newActive = true;
                }
            } else {
                this.crafter.decreaseEfficiencyTicks();
            }
            this.isActive.updateActive(newActive, (MachineBlockEntity)this);
        }
    }

    private static enum OperatingState {
        NOT_MATCHED,
        TRYING_TO_RESUME,
        NORMAL_OPERATION;

    }
}

