/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.CableTierHolder;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.tesseract.neoforge.compat.mi.serialization.MICodecs;
import net.swedz.tesseract.neoforge.compat.mi.serialization.MIStreamCodecs;

public record VoltageProcessCondition(CableTier tier) implements MachineProcessCondition
{
    public static final MapCodec<VoltageProcessCondition> CODEC = RecordCodecBuilder.mapCodec(g -> g.group((App)MICodecs.CABLE_TIER.fieldOf("voltage").forGetter(VoltageProcessCondition::tier)).apply((Applicative)g, VoltageProcessCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VoltageProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)MIStreamCodecs.CABLE_TIER, VoltageProcessCondition::tier, VoltageProcessCondition::new);

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        MachineBlockEntity machineBlockEntity = context.getBlockEntity();
        if (machineBlockEntity instanceof CableTierHolder) {
            CableTierHolder machine = (CableTierHolder)machineBlockEntity;
            return machine.getCableTier().eu >= this.tier.eu;
        }
        return false;
    }

    public void appendDescription(List<Component> lines) {
        lines.add((Component)MITweaks.text().recipeRequiresVoltage(this.tier));
    }

    public ItemStack icon() {
        ResourceLocation id = this.tier.itemKey == null ? MI.id((String)"basic_machine_hull") : this.tier.itemKey;
        return ((Block)BuiltInRegistries.BLOCK.get(id)).asItem().getDefaultInstance();
    }

    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }
}

