/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.client.renderer.MyRenderType;
import com.direwolf20.mininggadgets.common.blocks.RenderBlock;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.tiles.RenderBlockTileEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class RenderBlockTER
implements BlockEntityRenderer<RenderBlockTileEntity> {
    public RenderBlockTER(BlockEntityRendererProvider.Context p_173636_) {
    }

    private void renderModelBrightnessColorQuads(PoseStack.Pose matrixEntry, VertexConsumer builder, float red, float green, float blue, float alpha, List<BakedQuad> listQuads, int combinedLightsIn, int combinedOverlayIn) {
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.isTinted()) {
                f = red * 1.0f;
                f1 = green * 1.0f;
                f2 = blue * 1.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            builder.putBulkData(matrixEntry, bakedquad, f, f1, f2, alpha, combinedLightsIn, combinedOverlayIn, true);
        }
    }

    public void render(RenderBlockTileEntity tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        BlockState renderState;
        float nowScale;
        int durability = tile.getDurability();
        int originalDurability = tile.getOriginalDurability();
        int prevDurability = tile.getPriorDurability();
        float prevScale = (float)prevDurability / (float)originalDurability;
        float scale = Mth.lerp((float)partialTicks, (float)prevScale, (float)(nowScale = (float)durability / (float)originalDurability));
        if (scale >= 1.0f) {
            scale = 1.0f;
        }
        if (scale <= 0.0f) {
            scale = 0.0f;
        }
        if ((renderState = tile.getRenderBlock()) == null) {
            return;
        }
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        MiningProperties.BreakTypes breakType = tile.getBreakType();
        BakedModel ibakedmodel = blockrendererdispatcher.getBlockModel(renderState);
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        int color = blockColors.getColor(renderState, (BlockAndTintGetter)tile.getLevel(), tile.getBlockPos(), 0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        matrixStackIn.pushPose();
        if (breakType == MiningProperties.BreakTypes.SHRINK) {
            matrixStackIn.translate((1.0f - scale) / 2.0f, (1.0f - scale) / 2.0f, (1.0f - scale) / 2.0f);
            matrixStackIn.scale(scale, scale, scale);
            VertexConsumer builder = bufferIn.getBuffer(RenderType.cutout());
            for (Direction direction : Direction.values()) {
                this.renderModelBrightnessColorQuads(matrixStackIn.last(), builder, f, f1, f2, 1.0f, this.getQuads(ibakedmodel, tile, direction, RenderType.cutout()), combinedLightsIn, combinedOverlayIn);
            }
            this.renderModelBrightnessColorQuads(matrixStackIn.last(), builder, f, f1, f2, 1.0f, this.getQuads(ibakedmodel, tile, null, RenderType.cutout()), combinedLightsIn, combinedOverlayIn);
        } else if (breakType == MiningProperties.BreakTypes.FADE) {
            scale = Mth.lerp((float)scale, (float)0.1f, (float)1.0f);
            VertexConsumer builder = bufferIn.getBuffer(MyRenderType.RenderBlock);
            for (Direction direction : Direction.values()) {
                if (tile.getLevel().getBlockState(tile.getBlockPos().relative(direction)).getBlock() instanceof RenderBlock) continue;
                this.renderModelBrightnessColorQuads(matrixStackIn.last(), builder, f, f1, f2, scale, this.getQuads(ibakedmodel, tile, direction, MyRenderType.RenderBlock), combinedLightsIn, combinedOverlayIn);
            }
            this.renderModelBrightnessColorQuads(matrixStackIn.last(), builder, f, f1, f2, scale, this.getQuads(ibakedmodel, tile, null, MyRenderType.RenderBlock), combinedLightsIn, combinedOverlayIn);
        }
        matrixStackIn.popPose();
    }

    private List<BakedQuad> getQuads(BakedModel model, RenderBlockTileEntity tile, Direction side, RenderType type) {
        return model.getQuads(tile.getRenderBlock(), side, RandomSource.create((long)Mth.getSeed((Vec3i)tile.getBlockPos())), ModelData.EMPTY, type);
    }
}

