/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.network.data.ChangeBreakTypePayload;
import com.direwolf20.mininggadgets.common.network.data.ChangeColorPayload;
import com.direwolf20.mininggadgets.common.util.CodecHelpers;
import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.shorts.ShortConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;

public class MiningVisualsScreen
extends Screen {
    private ItemStack gadget;
    private Button blockBreakButton;
    private short red;
    private short green;
    private short blue;
    private short red_inner;
    private short green_inner;
    private short blue_inner;
    private ExtendedSlider sliderRedInner;
    private ExtendedSlider sliderGreenInner;
    private ExtendedSlider sliderBlueInner;
    private ExtendedSlider sliderRedOuter;
    private ExtendedSlider sliderGreenOuter;
    private ExtendedSlider sliderBlueOuter;
    private Map<ExtendedSlider, ShortConsumer> sliderMap = new HashMap<ExtendedSlider, ShortConsumer>();

    public MiningVisualsScreen(ItemStack gadget) {
        super((Component)Component.literal((String)"title"));
        this.gadget = gadget;
        CodecHelpers.LaserColor laserColor = MiningProperties.getColors(gadget);
        this.red = laserColor.red();
        this.green = laserColor.green();
        this.blue = laserColor.blue();
        this.red_inner = laserColor.innerRed();
        this.green_inner = laserColor.innerGreen();
        this.blue_inner = laserColor.innerBlue();
    }

    protected void init() {
        int baseX = this.width / 2;
        int baseY = this.height / 2;
        MutableComponent buttonText = MiningProperties.getBreakType(this.gadget) == MiningProperties.BreakTypes.SHRINK ? Component.translatable((String)"mininggadgets.tooltip.screen.shrink") : Component.translatable((String)"mininggadgets.tooltip.screen.fade");
        this.blockBreakButton = Button.builder((Component)buttonText, button -> {
            if (this.blockBreakButton.getMessage().getString().contains("Shrink")) {
                button.setMessage((Component)Component.translatable((String)"mininggadgets.tooltip.screen.fade"));
            } else {
                button.setMessage((Component)Component.translatable((String)"mininggadgets.tooltip.screen.shrink"));
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ChangeBreakTypePayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }).pos(baseX - 150, baseY - 55).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.blockBreakButton);
        this.sliderRedInner = new ExtendedSlider(baseX - 150, baseY - 10, 150, 20, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.red").append(": "), (Component)Component.empty(), 0.0, 255.0, this.red_inner, true){

            protected void applyValue() {
                MiningVisualsScreen.this.red_inner = (short)this.getValueInt();
            }
        };
        this.sliderGreenInner = new ExtendedSlider(baseX - 150, baseY + 15, 150, 20, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.green").append(": "), (Component)Component.empty(), 0.0, 255.0, this.green_inner, true){

            protected void applyValue() {
                MiningVisualsScreen.this.green_inner = (short)this.getValueInt();
            }
        };
        this.sliderBlueInner = new ExtendedSlider(baseX - 150, baseY + 40, 150, 20, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.blue").append(": "), (Component)Component.empty(), 0.0, 255.0, this.blue_inner, true){

            protected void applyValue() {
                MiningVisualsScreen.this.blue_inner = (short)this.getValueInt();
            }
        };
        this.sliderRedOuter = new ExtendedSlider(baseX + 25, baseY - 10, 150, 20, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.red").append(": "), (Component)Component.empty(), 0.0, 255.0, this.red, true){

            protected void applyValue() {
                MiningVisualsScreen.this.red = (short)this.getValueInt();
            }
        };
        this.sliderGreenOuter = new ExtendedSlider(baseX + 25, baseY + 15, 150, 20, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.green").append(": "), (Component)Component.empty(), 0.0, 255.0, this.green, true){

            protected void applyValue() {
                MiningVisualsScreen.this.green = (short)this.getValueInt();
            }
        };
        this.sliderBlueOuter = new ExtendedSlider(baseX + 25, baseY + 40, 150, 20, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.blue").append(": "), (Component)Component.empty(), 0.0, 255.0, this.blue, true){

            protected void applyValue() {
                MiningVisualsScreen.this.blue = (short)this.getValueInt();
            }
        };
        this.addRenderableWidget((GuiEventListener)this.sliderRedInner);
        this.addRenderableWidget((GuiEventListener)this.sliderGreenInner);
        this.addRenderableWidget((GuiEventListener)this.sliderBlueInner);
        this.addRenderableWidget((GuiEventListener)this.sliderRedOuter);
        this.addRenderableWidget((GuiEventListener)this.sliderGreenOuter);
        this.addRenderableWidget((GuiEventListener)this.sliderBlueOuter);
        this.sliderMap = Map.of(this.sliderRedInner, a -> {
            this.red_inner = a;
        }, this.sliderGreenInner, a -> {
            this.green_inner = a;
        }, this.sliderBlueInner, a -> {
            this.blue_inner = a;
        }, this.sliderRedOuter, a -> {
            this.red = a;
        }, this.sliderGreenOuter, a -> {
            this.green = a;
        }, this.sliderBlueOuter, a -> {
            this.blue = a;
        });
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.visual_settings"), this.width / 2, this.height / 2 - 95, 0xFFFFFF);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.block_break_style"), this.width / 2 - 150, this.height / 2 - 70, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.beam_preview"), this.width / 2 + 25, this.height / 2 - 70, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.inner_color"), this.width / 2 - 150, this.height / 2 - 25, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"mininggadgets.tooltip.screen.outer_color"), this.width / 2 + 25, this.height / 2 - 25, 0xFFFFFF, false);
        guiGraphics.pose().pushPose();
        guiGraphics.fill(this.width / 2 + 25, this.height / 2 - 55, this.width / 2 + 25 + 150, this.height / 2 - 55 + 20, this.rgbToInt(this.red, this.green, this.blue));
        guiGraphics.fill(this.width / 2 + 25, this.height / 2 - 50, this.width / 2 + 25 + 150, this.height / 2 - 50 + 10, this.rgbToInt(this.red_inner, this.green_inner, this.blue_inner));
        guiGraphics.pose().popPose();
    }

    private int rgbToInt(int r, int g, int b) {
        int red = r << 16 & 0xFF0000;
        int green = g << 8 & 0xFF00;
        int blue = b & 0xFF;
        return 0xFF000000 | red | green | blue;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        this.sliderMap.forEach((slider, consumer) -> {
            if (slider.isMouseOver(mouseX, mouseY)) {
                slider.setValue((double)(slider.getValueInt() + (delta > 0.0 ? 1 : -1)));
                consumer.accept(slider.getValueInt());
            }
        });
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void removed() {
        super.removed();
    }

    private void syncColors() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeColorPayload(new CodecHelpers.LaserColor(this.red, this.green, this.blue, this.red_inner, this.green_inner, this.blue_inner)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256) {
            this.syncColors();
            ModScreens.openGadgetSettingsScreen(this.gadget);
            return true;
        }
        if (this.getMinecraft().options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.syncColors();
            this.removed();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

