/*
 * Decompiled with CFR 0.152.
 */
package uk.co.hexeption.minis.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import uk.co.hexeption.minis.entity.MiniEntity;

public class CustomCapeLayer
extends RenderLayer<MiniEntity, PlayerModel<MiniEntity>> {
    public CustomCapeLayer(RenderLayerParent pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, MiniEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        PlayerSkin playerSkin = pLivingEntity.getSkin();
        if (playerSkin.capeTexture() != null) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 0.0f, 0.125f);
            double d0 = Mth.lerp((double)pPartialTick, (double)pLivingEntity.xCloakO, (double)pLivingEntity.xCloak) - Mth.lerp((double)pPartialTick, (double)pLivingEntity.xo, (double)pLivingEntity.getX());
            double d1 = Mth.lerp((double)pPartialTick, (double)pLivingEntity.yCloakO, (double)pLivingEntity.yCloak) - Mth.lerp((double)pPartialTick, (double)pLivingEntity.yo, (double)pLivingEntity.getY());
            double d2 = Mth.lerp((double)pPartialTick, (double)pLivingEntity.zCloakO, (double)pLivingEntity.zCloak) - Mth.lerp((double)pPartialTick, (double)pLivingEntity.zo, (double)pLivingEntity.getZ());
            float f = Mth.rotLerp((float)pPartialTick, (float)pLivingEntity.yBodyRotO, (float)pLivingEntity.yBodyRot);
            double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.clamp((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = Mth.clamp((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.clamp((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = Mth.lerp((float)pPartialTick, (float)pLivingEntity.oBob, (float)pLivingEntity.bob);
            f1 += Mth.sin((float)(Mth.lerp((float)pPartialTick, (float)pLivingEntity.walkDistO, (float)pLivingEntity.walkDist) * 6.0f)) * 32.0f * f4;
            if (pLivingEntity.isCrouching()) {
                f1 += 25.0f;
            }
            pPoseStack.mulPose(Axis.XP.rotationDegrees(6.0f + f2 / 2.0f + f1));
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(f3 / 2.0f));
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f3 / 2.0f));
            VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entitySolid((ResourceLocation)playerSkin.capeTexture()));
            ((PlayerModel)this.getParentModel()).renderCloak(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
            pPoseStack.popPose();
        }
    }
}

