/*
 * Decompiled with CFR 0.152.
 */
package uk.co.hexeption.minis.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import uk.co.hexeption.minis.util.SkinUtil;

public class MiniEntity
extends PathfinderMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(MiniEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private ResolvableProfile owner;
    private String textureB64 = null;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    public float oBob;
    public float bob;

    public MiniEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return MiniEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(OWNER_UNIQUE_ID, Optional.empty());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getSkinLocation() {
        if (this.getOwnerId() == null) {
            this.setOwnerId(Minecraft.getInstance().player.getUUID());
        }
        if (this.textureB64 == null) {
            this.textureB64 = SkinUtil.getHeadValue(this.getOwnerId());
        }
        if (this.textureB64.equals("nil")) {
            return DefaultPlayerSkin.get((UUID)this.getOwnerId()).texture();
        }
        GameProfile gameProfile = new GameProfile(this.getOwnerId(), "MiniEntity");
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", this.textureB64));
        if (gameProfile.getProperties().get((Object)"textures") != null) {
            SkinManager manager = Minecraft.getInstance().getSkinManager();
            PlayerSkin map = manager.getInsecureSkin(gameProfile);
            if (map != null) {
                return map.texture();
            }
            UUID uuid = UUIDUtil.createOfflinePlayerUUID((String)gameProfile.getName());
            return DefaultPlayerSkin.get((UUID)uuid).texture();
        }
        UUID uuid = UUIDUtil.createOfflinePlayerUUID((String)gameProfile.getName());
        return DefaultPlayerSkin.get((UUID)uuid).texture();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getOwnerId() != null) {
            compound.putUUID("Owner", this.getOwnerId());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
        SkullBlockEntity.fetchGameProfile((UUID)this.getOwnerId()).thenAccept(gameProfile -> this.setCustomName((Component)Component.literal((String)((GameProfile)gameProfile.get()).getName())));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PlayerSkin getSkin() {
        PlayerSkin skin;
        Optional profile = SkullBlockEntity.fetchGameProfile((UUID)this.getOwnerId()).getNow(null);
        if (profile != null && (skin = Minecraft.getInstance().getSkinManager().getInsecureSkin((GameProfile)profile.get())) != null) {
            return skin;
        }
        return DefaultPlayerSkin.get((UUID)this.getOwnerId());
    }

    public void tick() {
        super.tick();
        this.moveCloak();
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d0 = this.getX() - this.xCloak;
        double d1 = this.getY() - this.yCloak;
        double d2 = this.getZ() - this.zCloak;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 > 10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 > 10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        if (d0 < -10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if (d2 < -10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if (d1 < -10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        this.xCloak += d0 * 0.25;
        this.zCloak += d2 * 0.25;
        this.yCloak += d1 * 0.25;
    }
}

