/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.deduplicate_wall_shapes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WallBlock.class})
public abstract class WallBlockMixin
extends Block {
    private static Map<ImmutableList<Float>, Pair<Map<Map<Property<?>, Comparable<?>>, VoxelShape>, StateDefinition<Block, BlockState>>> CACHE_BY_SHAPE_VALS = new HashMap();

    public WallBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"makeShapes"}, at={@At(value="HEAD")}, cancellable=true)
    private synchronized void useCachedShapeMap(float f1, float f2, float f3, float f4, float f5, float f6, CallbackInfoReturnable<Map<BlockState, VoxelShape>> cir) {
        ImmutableList key = ImmutableList.of((Object)Float.valueOf(f1), (Object)Float.valueOf(f2), (Object)Float.valueOf(f3), (Object)Float.valueOf(f4), (Object)Float.valueOf(f5), (Object)Float.valueOf(f6));
        Pair<Map<Map<Property<?>, Comparable<?>>, VoxelShape>, StateDefinition<Block, BlockState>> cache = CACHE_BY_SHAPE_VALS.get(key);
        if (cache == null || !((StateDefinition)cache.getSecond()).getProperties().equals(this.stateDefinition.getProperties())) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : this.stateDefinition.getPossibleStates()) {
            VoxelShape shape = (VoxelShape)((Map)cache.getFirst()).get(state.getValues());
            if (shape == null) {
                return;
            }
            builder.put((Object)state, (Object)shape);
        }
        cir.setReturnValue((Object)builder.build());
    }

    @Inject(method={"makeShapes"}, at={@At(value="RETURN")})
    private synchronized void storeCachedShapesByProperty(float f1, float f2, float f3, float f4, float f5, float f6, CallbackInfoReturnable<Map<BlockState, VoxelShape>> cir) {
        if (((Object)((Object)this)).getClass() != WallBlock.class) {
            return;
        }
        ImmutableList key = ImmutableList.of((Object)Float.valueOf(f1), (Object)Float.valueOf(f2), (Object)Float.valueOf(f3), (Object)Float.valueOf(f4), (Object)Float.valueOf(f5), (Object)Float.valueOf(f6));
        if (!CACHE_BY_SHAPE_VALS.containsKey(key)) {
            HashMap<Map, VoxelShape> cacheByProperties = new HashMap<Map, VoxelShape>();
            Map shapeMap = (Map)cir.getReturnValue();
            for (Map.Entry entry : shapeMap.entrySet()) {
                cacheByProperties.put(((BlockState)entry.getKey()).getValues(), (VoxelShape)entry.getValue());
            }
            CACHE_BY_SHAPE_VALS.put((ImmutableList<Float>)key, Pair.of(cacheByProperties, (Object)this.stateDefinition));
        }
    }
}

