/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.BookTextHolderModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.klikli_dev.modonomicon.book.page.BookSpotlightPage;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BookSpotlightPageModel
extends BookPageModel<BookSpotlightPageModel> {
    protected Either<ItemStack, Ingredient> item = Either.right((Object)Ingredient.EMPTY);
    protected BookTextHolderModel title = new BookTextHolderModel("");
    protected BookTextHolderModel text = new BookTextHolderModel("");

    protected BookSpotlightPageModel() {
        super(ModonomiconConstants.Data.Page.SPOTLIGHT);
    }

    public static BookSpotlightPageModel create() {
        return new BookSpotlightPageModel();
    }

    public BookTextHolderModel getTitle() {
        return this.title;
    }

    public Either<ItemStack, Ingredient> getItem() {
        return this.item;
    }

    public BookTextHolderModel getText() {
        return this.text;
    }

    @Override
    public JsonObject toJson(ResourceLocation entryId, HolderLookup.Provider provider) {
        JsonObject json = super.toJson(entryId, provider);
        json.add("title", this.title.toJson(provider));
        json.add("item", (JsonElement)BookSpotlightPage.ITEM_CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), this.item).getOrThrow());
        json.add("text", this.text.toJson(provider));
        return json;
    }

    public BookSpotlightPageModel withTitle(String title) {
        this.title = new BookTextHolderModel(title);
        return this;
    }

    public BookSpotlightPageModel withTitle(Component title) {
        this.title = new BookTextHolderModel(title);
        return this;
    }

    public BookSpotlightPageModel withItem(Ingredient item) {
        this.item = Either.right((Object)item);
        return this;
    }

    public BookSpotlightPageModel withItem(ItemStack item) {
        this.item = Either.left((Object)item);
        return this;
    }

    public BookSpotlightPageModel withItem(ItemLike item) {
        this.item = Either.left((Object)new ItemStack(item));
        return this;
    }

    public BookSpotlightPageModel withItem(Item item) {
        this.item = Either.left((Object)new ItemStack((ItemLike)item));
        return this;
    }

    public BookSpotlightPageModel withText(String text) {
        this.text = new BookTextHolderModel(text);
        return this;
    }

    public BookSpotlightPageModel withText(Component text) {
        this.text = new BookTextHolderModel(text);
        return this;
    }
}

