/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.client.render.area.IPositionProvider;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ITargetedModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import me.desht.modularrouters.logic.compiled.CompiledEnergyDistributorModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.capabilities.Capabilities;

public class EnergyDistributorModule
extends ModuleItem
implements IRangedModule,
IPositionProvider,
ITargetedModule {
    private static final TintColor TINT_COLOR = new TintColor(79, 9, 90);

    public EnergyDistributorModule() {
        super(ModItems.moduleProps().component(ModDataComponents.DISTRIBUTOR_SETTINGS, (Object)CompiledDistributorModule.DistributorSettings.DEFAULT), CompiledEnergyDistributorModule::new);
    }

    @Override
    protected void addSettingsInformation(ItemStack stack, List<Component> list) {
        super.addSettingsInformation(stack, list);
        CompiledDistributorModule.DistributorSettings settings = (CompiledDistributorModule.DistributorSettings)stack.getOrDefault(ModDataComponents.DISTRIBUTOR_SETTINGS, (Object)CompiledDistributorModule.DistributorSettings.DEFAULT);
        list.add((Component)ClientUtil.xlate(settings.direction().getTranslationKey(), new Object[0]).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    @Override
    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.ENERGY_DISTRIBUTOR_MENU.get();
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        return (Integer)ConfigHolder.common.energyCosts.energydistributorModuleEnergyCost.get();
    }

    @Override
    public int getBaseRange() {
        return 8;
    }

    @Override
    public int getHardMaxRange() {
        return 48;
    }

    @Override
    public boolean isValidTarget(UseOnContext ctx) {
        return ctx.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, ctx.getClickedPos(), (Object)ctx.getClickedFace()) != null;
    }

    @Override
    public int getMaxTargets() {
        return 8;
    }

    @Override
    public int getRenderColor(int index) {
        return -2132770688;
    }
}

