/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import me.desht.modularrouters.api.matching.IModuleFlags;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ModuleFlags(boolean whiteList, boolean matchDamage, boolean matchComponents, boolean matchItemTags, boolean matchAllItems) implements IModuleFlags
{
    public static final ModuleFlags DEFAULT = new ModuleFlags(false, true, false, false, false);
    public static final Codec<ModuleFlags> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("white_list", (Object)false).forGetter(ModuleFlags::whiteList), (App)Codec.BOOL.optionalFieldOf("match_damage", (Object)false).forGetter(ModuleFlags::matchDamage), (App)Codec.BOOL.optionalFieldOf("match_components", (Object)false).forGetter(ModuleFlags::matchComponents), (App)Codec.BOOL.optionalFieldOf("match_item_tag", (Object)false).forGetter(ModuleFlags::matchItemTags), (App)Codec.BOOL.optionalFieldOf("match_all", (Object)false).forGetter(ModuleFlags::matchAllItems)).apply((Applicative)builder, ModuleFlags::new));
    public static final StreamCodec<ByteBuf, ModuleFlags> STREAM_CODEC = new StreamCodec<ByteBuf, ModuleFlags>(){

        public ModuleFlags decode(ByteBuf buf) {
            byte val = buf.readByte();
            boolean whiteList = (val & 1) != 0;
            boolean ignoreDamage = (val & 2) != 0;
            boolean ignoreComp = (val & 4) != 0;
            boolean ignoreTags = (val & 8) != 0;
            boolean matchAll = (val & 0x10) != 0;
            return new ModuleFlags(whiteList, ignoreDamage, ignoreComp, ignoreTags, matchAll);
        }

        public void encode(ByteBuf buf, ModuleFlags flags) {
            byte val = 0;
            if (flags.whiteList) {
                val = (byte)(val | 1);
            }
            if (flags.matchDamage) {
                val = (byte)(val | 2);
            }
            if (flags.matchComponents) {
                val = (byte)(val | 4);
            }
            if (flags.matchItemTags) {
                val = (byte)(val | 8);
            }
            if (flags.matchAllItems) {
                val = (byte)(val | 0x10);
            }
            buf.writeByte((int)val);
        }
    };

    public static ModuleFlags forItem(ItemStack stack) {
        return stack.getItem() instanceof ModuleItem ? ModuleItem.getCommonSettings(stack).flags() : DEFAULT;
    }
}

