/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class PotionTrade
extends TransformableTrade<PotionTrade> {
    @Nullable
    List<Holder<Potion>> potions;
    private Item itemForPotion = Items.POTION;
    private boolean onlyBrewablePotion;
    private boolean noBrewablePotion;

    public PotionTrade(TradeItem[] inputs) {
        super(inputs);
    }

    public PotionTrade item(Item item) {
        this.itemForPotion = item;
        return this;
    }

    public PotionTrade potions(Potion ... potions) {
        this.potions = Arrays.stream(potions).peek(e -> {
            if (e == null) {
                ConsoleJS.SERVER.error((Object)("Null potion in array: " + Arrays.toString(potions)));
            }
        }).filter(Objects::nonNull).map(arg_0 -> ((Registry)BuiltInRegistries.POTION).wrapAsHolder(arg_0)).toList();
        return this;
    }

    public PotionTrade onlyBrewablePotion() {
        this.onlyBrewablePotion = true;
        return this;
    }

    public PotionTrade noBrewablePotion() {
        this.noBrewablePotion = false;
        return this;
    }

    private List<? extends Holder<Potion>> getFilteredPotions(PotionBrewing potionBrewing, Stream<? extends Holder<Potion>> potions) {
        return potions.filter(potionHolder -> {
            if (((Potion)potionHolder.value()).getEffects().isEmpty()) {
                return false;
            }
            if (this.onlyBrewablePotion) {
                return potionBrewing.isBrewablePotion(potionHolder);
            }
            if (this.noBrewablePotion) {
                return !potionBrewing.isBrewablePotion(potionHolder);
            }
            return true;
        }).toList();
    }

    @Override
    @Nullable
    public MerchantOffer createOffer(Entity entity, RandomSource random) {
        List<? extends Holder<Potion>> allowedPotions;
        PotionBrewing potionBrewing = entity.level().potionBrewing();
        List<? extends Holder<Potion>> list = allowedPotions = this.potions == null ? this.getFilteredPotions(potionBrewing, BuiltInRegistries.POTION.holders()) : this.getFilteredPotions(potionBrewing, this.potions.stream());
        if (allowedPotions.isEmpty()) {
            return null;
        }
        Holder<Potion> potion = allowedPotions.get(random.nextInt(this.potions.size()));
        ItemStack itemStack = new ItemStack((ItemLike)this.itemForPotion);
        itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        return this.createOffer(itemStack, random);
    }
}

