/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class StewTrade
extends TransformableTrade<StewTrade> {
    private final List<SuspiciousStewEffects.Entry> effects = new ArrayList<SuspiciousStewEffects.Entry>();

    public StewTrade(TradeItem[] inputs) {
        super(inputs);
    }

    public StewTrade addEffect(MobEffect effect, int duration) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        Holder mobEffectHolder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect);
        this.effects.add(new SuspiciousStewEffects.Entry(mobEffectHolder, duration));
        return this;
    }

    @Override
    @Nullable
    public MerchantOffer createOffer(Entity entity, RandomSource random) {
        ItemStack stew = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
        List<SuspiciousStewEffects.Entry> effectCopy = List.copyOf(this.effects);
        stew.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)new SuspiciousStewEffects(effectCopy));
        return this.createOffer(stew, random);
    }
}

