/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.bitwise_logic;

import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChanneledPowerStorageBlockEntity
extends BlockEntity {
    public static final String POWER = "power";
    protected byte[] power = new byte[16];

    public static ChanneledPowerStorageBlockEntity create(BlockPos pos, BlockState state) {
        return new ChanneledPowerStorageBlockEntity((BlockEntityType<? extends ChanneledPowerStorageBlockEntity>)((BlockEntityType)MoreRed.get().bitwiseLogicGateBeType.get()), pos, state);
    }

    public ChanneledPowerStorageBlockEntity(BlockEntityType<? extends ChanneledPowerStorageBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ChanneledPowerStorageBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ChanneledPowerStorageBlockEntity>)((BlockEntityType)MoreRed.get().bitwiseLogicGateBeType.get()), pos, state);
    }

    public ChanneledPowerSupplier getChanneledPower(Direction side) {
        return side == PlateBlockStateProperties.getOutputDirection(this.getBlockState()) ? this::getPowerOnChannel : null;
    }

    public int getPowerOnChannel(Level level, BlockPos wirePos, BlockState wireState, Direction wireFace, int channel) {
        BlockState thisState = this.getBlockState();
        return wireFace == null || thisState.getBlock() instanceof PlateBlock && wireFace == thisState.getValue((Property)PlateBlock.ATTACHMENT_DIRECTION) ? this.getPower(channel) : 0;
    }

    public int getPower(int channel) {
        return this.power[channel];
    }

    public boolean setPower(byte[] newPowers) {
        boolean updated = false;
        for (int i = 0; i < 16; ++i) {
            byte newPower = newPowers[i];
            byte oldPower = this.power[i];
            if (newPower == oldPower) continue;
            this.power[i] = newPower;
            updated = true;
        }
        if (updated && !this.level.isClientSide) {
            this.setChanged();
            return true;
        }
        return false;
    }

    public boolean setPower(int channel, int newPower) {
        byte oldPower = this.power[channel];
        this.power[channel] = (byte)newPower;
        if (oldPower != newPower) {
            if (!this.level.isClientSide) {
                this.setChanged();
            }
            return true;
        }
        return false;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putByteArray(POWER, (byte[])this.power.clone());
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        byte[] newPower = compound.getByteArray(POWER);
        if (newPower.length == 16) {
            this.power = (byte[])newPower.clone();
        }
    }

    public void updatePower() {
        byte[] powers = this.getStrongestNeighborPower();
        this.setPower(powers);
    }

    public byte[] getStrongestNeighborPower() {
        return new byte[16];
    }
}

