/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import commoble.morered.MoreRed;
import commoble.morered.wires.AbstractWireBlock;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class WireCountLootFunction
implements LootItemFunction {
    public static final WireCountLootFunction INSTANCE = new WireCountLootFunction();
    public static final MapCodec<WireCountLootFunction> CODEC = MapCodec.unit((Object)INSTANCE);

    public ItemStack apply(ItemStack input, LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        Block block = state.getBlock();
        if (block instanceof AbstractWireBlock) {
            input.setCount(((AbstractWireBlock)block).getWireCount(state));
        }
        return input;
    }

    public LootItemFunctionType<WireCountLootFunction> getType() {
        return (LootItemFunctionType)MoreRed.get().wireCountLootFunction.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.BLOCK_STATE);
    }
}

