/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.blocks.blockentities;

import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.FakeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerBlock
extends BaseEntityBlock {
    public ContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract boolean tickingEnabled();

    public abstract BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType();

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.getBlockEntityType().create(blockPos, blockState);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!this.tickingEnabled()) {
            return null;
        }
        return ContainerBlock.createTickerHelper(blockEntityType, this.getBlockEntityType(), (level1, pos1, state1, entity1) -> entity1.commonTick());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof ContainerBlockEntity) {
            ContainerBlockEntity containerBE = (ContainerBlockEntity)be;
            if (!state.is(newState.getBlock())) {
                containerBE.drop();
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MenuProvider) {
            FakeBlockEntity fakeBlockEntity;
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            BlockPos pos1 = pos;
            if (blockEntity instanceof FakeBlockEntity && (fakeBlockEntity = (FakeBlockEntity)blockEntity).getActualBlockEntityPos() != null) {
                pos1 = fakeBlockEntity.getActualBlockEntityPos();
            }
            player.openMenu(menuProvider, pos1);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

