/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.blocks.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.blocks.DisplayBlock;
import com.portingdeadmods.nautec.api.blocks.blockentities.ContainerBlock;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LaserBlock
extends ContainerBlock
implements DisplayBlock,
SimpleWaterloggedBlock {
    public LaserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        if (this.waterloggable()) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean tickingEnabled() {
        return true;
    }

    public abstract boolean waterloggable();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(this.waterloggable() ? builder.add(new Property[]{BlockStateProperties.WATERLOGGED}) : builder);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (this.waterloggable() && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = super.getStateForPlacement(context);
        return state != null && this.waterloggable() ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER)) : state;
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return this.waterloggable() && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public List<Component> displayText(Level level, BlockPos blockPos, Player player) {
        LaserBlockEntity laserBE = (LaserBlockEntity)level.getBlockEntity(blockPos);
        return List.of(Component.literal((String)("Power: " + laserBE.getPower())).withStyle(ChatFormatting.WHITE), Component.literal((String)("Purity: " + laserBE.getPurity())).withStyle(ChatFormatting.WHITE));
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (this.waterloggable()) {
            return super.canPlaceLiquid(player, level, pos, state, fluid);
        }
        return false;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (this.waterloggable()) {
            return super.placeLiquid(level, pos, state, fluidState);
        }
        return false;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        if (this.waterloggable()) {
            return super.pickupBlock(player, level, pos, state);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return this.waterloggable() ? super.getPickupSound() : Optional.empty();
    }
}

