/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.multiblocks;

import com.portingdeadmods.nautec.api.multiblocks.MultiblockLayer;
import com.portingdeadmods.nautec.api.utils.HorizontalDirection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public record MultiblockData(boolean valid, HorizontalDirection direction, MultiblockLayer[] layers) {
    public static final MultiblockData EMPTY = new MultiblockData(false, HorizontalDirection.NORTH, new MultiblockLayer[0]);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("layersLength", this.layers.length);
        CompoundTag listTag = new CompoundTag();
        int expandedLayersLength = this.layers.length;
        for (int i = 0; i < expandedLayersLength; ++i) {
            MultiblockLayer layer = this.layers[i];
            listTag.put(String.valueOf(i), (Tag)layer.save());
        }
        tag.put("layersList", (Tag)listTag);
        tag.putInt("direction", this.direction.ordinal());
        tag.putBoolean("valid", this.valid);
        return tag;
    }

    public static MultiblockData deserializeNBT(CompoundTag nbt) {
        int layersLength = nbt.getInt("layersLength");
        CompoundTag listTag = nbt.getCompound("layersList");
        MultiblockLayer[] layers = new MultiblockLayer[layersLength];
        for (int i = 0; i < layers.length; ++i) {
            layers[i] = MultiblockLayer.load(listTag.getCompound(String.valueOf(i)));
        }
        HorizontalDirection direction = HorizontalDirection.values()[nbt.getInt("direction")];
        boolean valid = nbt.getBoolean("valid");
        return new MultiblockData(valid, direction, layers);
    }
}

