/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.multiblocks;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import net.minecraft.nbt.CompoundTag;
import org.apache.commons.lang3.IntegerRange;

public record MultiblockLayer(boolean dynamic, IntegerRange range, int[] layer, IntIntPair widths) {
    public MultiblockLayer(boolean dynamic, IntegerRange range, int[] layer) {
        this(dynamic, range, layer, IntIntPair.of((int)((int)Math.sqrt(layer.length)), (int)((int)Math.sqrt(layer.length))));
    }

    public MultiblockLayer setDynamic(IntegerRange size) {
        return new MultiblockLayer(true, size, this.layer, this.widths);
    }

    public MultiblockLayer setWidths(int xWidth, int zWidth) {
        return new MultiblockLayer(this.dynamic, this.range, this.layer, IntIntPair.of((int)xWidth, (int)zWidth));
    }

    public static MultiblockLayer load(CompoundTag tag) {
        return new MultiblockLayer(tag.getBoolean("dynamic"), IntegerRange.of((int)tag.getInt("rangeMin"), (int)tag.getInt("rangeMax")), tag.getIntArray("layer"), IntIntPair.of((int)tag.getInt("widthsX"), (int)tag.getInt("widthsZ")));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("dynamic", this.dynamic);
        tag.putInt("rangeMin", ((Integer)this.range.getMinimum()).intValue());
        tag.putInt("rangeMax", ((Integer)this.range.getMaximum()).intValue());
        tag.putIntArray("layer", this.layer);
        tag.putInt("widthsX", this.widths.leftInt());
        tag.putInt("widthsZ", this.widths.rightInt());
        return tag;
    }

    public IntIntPair getWidths() {
        return this.widths;
    }
}

