/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.model.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class DrainTopModel
extends Model {
    public static final Material DRAIN_TOP_LOCATION = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"entity/drain_top"));
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"drain_top"), "main");
    private final ModelPart top;
    private final ModelPart valve;

    public DrainTopModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.top = root.getChild("top");
        this.valve = root.getChild("valve");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition top = partdefinition.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 0).addBox(-30.0f, -19.0f, -14.0f, 44.0f, 3.0f, 44.0f, new CubeDeformation(0.0f)).texOffs(0, 47).addBox(-20.0f, -21.0f, -4.0f, 24.0f, 2.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)40.0f, (float)-8.0f));
        PartDefinition cube_r1 = top.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -3.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.0f, (float)-18.0042f, (float)-5.9937f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = top.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(14, 0).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-22.0f, (float)-18.0042f, (float)9.0063f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r3 = top.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(14, 8).addBox(-3.0f, -2.0f, -1.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)-18.0042f, (float)7.0063f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r4 = top.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 8).addBox(-3.0f, -2.0f, -3.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-18.0042f, (float)22.0063f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition valve = partdefinition.addOrReplaceChild("valve", CubeListBuilder.create().texOffs(56, 47).addBox(-8.0f, -9.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-2.0f, -9.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.renderLid(poseStack, buffer, packedLight, packedOverlay);
        this.renderValve(poseStack, buffer, packedLight, packedOverlay);
    }

    public void renderLid(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(1.0f, -1.0f, 1.0f);
        this.top.render(poseStack, buffer, packedLight, packedOverlay, -1);
        poseStack.popPose();
    }

    public void renderValve(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        this.valve.render(poseStack, buffer, packedLight, packedOverlay, -1);
        poseStack.popPose();
    }

    public void setupAnimation() {
        this.top.xRot = (float)Math.toRadians(180.0);
        this.top.x = 0.0f;
        this.top.y = 0.0f;
        this.top.z = 0.0f;
        this.valve.xRot = (float)Math.toRadians(180.0);
        this.valve.x = 0.0f;
        this.valve.y = 0.0f;
        this.valve.z = 0.0f;
    }
}

