/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.screen;

import com.mojang.blaze3d.vertex.Tesselator;
import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import org.jetbrains.annotations.NotNull;

public class AugmentationStationDataPanel
extends ScrollPanel {
    private List<AugmentSlot> augmentSlots;
    private final Minecraft client;
    private AugmentSlot selectedSlot;

    public AugmentationStationDataPanel(Minecraft client, int width, int height, int top, int left) {
        super(client, width, height, top, left);
        this.client = client;
        this.augmentSlots = Collections.emptyList();
        this.applyScrollLimits();
    }

    private int getMaxScroll() {
        int contentHeight = this.getContentHeight();
        return Math.max(contentHeight - (this.height - this.border), 0);
    }

    private void applyScrollLimits() {
        int max = this.getMaxScroll();
        if (max < 0) {
            max /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)max) {
            this.scrollDistance = max;
        }
    }

    protected int getContentHeight() {
        int n = this.augmentSlots.size();
        Objects.requireNonNull(this.client.font);
        return n * 9;
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        Nautec.LOGGER.debug("relative y: {}", (Object)relativeY);
        for (int i = 0; i < this.augmentSlots.size(); ++i) {
            AugmentSlot augmentSlot = this.augmentSlots.get(i);
            int x = this.left + 2;
            Objects.requireNonNull(this.client.font);
            int y = relativeY - 2 + i * 9;
            ResourceLocation loc = NTRegistries.AUGMENT_SLOT.getKey((Object)augmentSlot);
            guiGraphics.drawString(this.client.font, (Component)Component.translatable((String)("augment_slot." + loc.getNamespace() + "." + loc.getPath())), x, y, FastColor.ARGB32.color((int)255, (int)255, (int)255));
        }
    }

    public void setAugmentSlots(List<AugmentSlot> augmentSlots) {
        this.applyScrollLimits();
        this.augmentSlots = augmentSlots;
    }

    public AugmentSlot getSelectedSlot() {
        return this.selectedSlot;
    }

    public int getSelectedSlotIndex() {
        return this.selectedSlot != null ? this.augmentSlots.indexOf(this.selectedSlot) : -1;
    }

    @NotNull
    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected boolean clickPanel(double mouseX, double mouseY, int button) {
        Objects.requireNonNull(this.client.font);
        int augmentIndex = (int)(mouseY / 9.0);
        if (augmentIndex >= 0) {
            this.selectedSlot = this.augmentSlots.get(augmentIndex);
            return true;
        }
        return super.clickPanel(mouseX, mouseY, button);
    }
}

