/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei.categories;

import com.portingdeadmods.nautec.compat.jei.categories.BacteriaCategory;
import com.portingdeadmods.nautec.content.recipes.BacteriaIncubationRecipe;
import com.portingdeadmods.nautec.registries.NTBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BacteriaIncubationCategory
extends BacteriaCategory<BacteriaIncubationRecipe> {
    static final ResourceLocation SINGLE_SLOT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/furnace/empty_slot");
    static final ResourceLocation RIGHT_ARROW_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/incubator/progress_arrow_off");
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"bacteria_incubation");
    public static final RecipeType<BacteriaIncubationRecipe> RECIPE_TYPE = new RecipeType(UID, BacteriaIncubationRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final int gap = 5;
    private final int slotSize = 18;
    private final int arrowWidth = 79;
    private final int YGapBetweenInCata = 29;
    private final int gapBetweenSlotArrow = 3;
    private final int drawableWidth = 131;
    private final int drawableHeight = 65;

    public BacteriaIncubationCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(131, 65);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)NTBlocks.INCUBATOR.get()));
    }

    public RecipeType<BacteriaIncubationRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Bacteria Incubation");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BacteriaIncubationRecipe recipe, IFocusGroup focuses) {
        this.addBacteriaSlot(recipe, 57, 12, recipe.bacteria());
        builder.addSlot(RecipeIngredientRole.INPUT, 58, 34).addIngredients(recipe.nutrient());
    }

    @Override
    public void draw(@NotNull BacteriaIncubationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blitSprite(RIGHT_ARROW_SPRITE, 43, 3, 46, 29);
        guiGraphics.blitSprite(SINGLE_SLOT_SPRITE, 57, 33, 18, 18);
        Font font = Minecraft.getInstance().font;
        String chanceText = recipe.consumeChance() * 100.0f + "%";
        String growthText = "Growth: " + recipe.growth().toString();
        guiGraphics.drawString(font, chanceText, this.getWidth() / 2 + 15, this.getHeight() - 26, -8355712, false);
        int growthWidth = font.width(growthText);
        guiGraphics.drawString(font, growthText, this.getWidth() / 2 - growthWidth / 2, this.getHeight() - 9, -8355712, false);
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

