/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei.categories;

import com.portingdeadmods.nautec.content.recipes.ItemTransformationRecipe;
import com.portingdeadmods.nautec.content.recipes.utils.RecipeUtils;
import com.portingdeadmods.nautec.registries.NTBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ItemTransformationRecipeCategory
implements IRecipeCategory<ItemTransformationRecipe> {
    static final ResourceLocation BURN_PROGRESS_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/furnace/empty_arrow");
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"item_transformation");
    public static final RecipeType<ItemTransformationRecipe> RECIPE_TYPE = new RecipeType(UID, ItemTransformationRecipe.class);
    private final IDrawable icon;
    private final IDrawable background;

    public ItemTransformationRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(80, 28);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)NTBlocks.PRISMARINE_RELAY.get()));
    }

    public RecipeType<ItemTransformationRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Item Transformation");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ItemTransformationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blitSprite(BURN_PROGRESS_SPRITE, 28, 0, 24, 16);
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, (float)recipe.duration() / 20.0f + "s", 0, 20, -8355712, false);
        String purityString = recipe.purity() + " purity";
        int width = font.width(purityString);
        guiGraphics.drawString(font, purityString, this.getWidth() - width, 20, -8355712, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ItemTransformationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addIngredients(RecipeUtils.iWCToIngredientSaveCount(recipe.ingredient()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 64, 0).addItemStack(recipe.getResultItem(null));
    }

    private boolean shouldRenderTooltip(double mouseX, double mouseY) {
        int width = 24;
        int height = 16;
        int x = 28;
        int y = 0;
        boolean matchesOnX = mouseX > (double)x && mouseX < (double)(x + width);
        boolean matchesOnY = mouseY > (double)y && mouseY < (double)(y + height);
        return matchesOnX && matchesOnY;
    }
}

