/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.bacteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.bacteria.BacteriaSerializer;
import com.portingdeadmods.nautec.api.bacteria.BacteriaStats;
import com.portingdeadmods.nautec.content.bacteria.SimpleBacteriaStats;
import com.portingdeadmods.nautec.utils.RNGUtils;
import com.portingdeadmods.nautec.utils.ranges.FloatRange;
import com.portingdeadmods.nautec.utils.ranges.IntRange;
import com.portingdeadmods.nautec.utils.ranges.LongRange;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public final class SimpleBacteria
extends Record
implements Bacteria {
    private final LongRange initialSize;
    private final Bacteria.Resource.ItemResource resource;
    private final BacteriaStats<?> stats;

    public SimpleBacteria(LongRange initialSize, Bacteria.Resource.ItemResource resource, BacteriaStats<?> stats) {
        this.initialSize = initialSize;
        this.resource = resource;
        this.stats = stats;
    }

    public static Builder of() {
        return new Builder();
    }

    @Override
    public long rollSize() {
        return RNGUtils.uniformRandLong((Long)this.initialSize.getMin(), (Long)this.initialSize.getMax());
    }

    public BacteriaSerializer<SimpleBacteria> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SimpleBacteria.class, "initialSize;resource;stats", "initialSize", "resource", "stats"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SimpleBacteria.class, "initialSize;resource;stats", "initialSize", "resource", "stats"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SimpleBacteria.class, "initialSize;resource;stats", "initialSize", "resource", "stats"}, this, o);
    }

    @Override
    public LongRange initialSize() {
        return this.initialSize;
    }

    @Override
    public Bacteria.Resource.ItemResource resource() {
        return this.resource;
    }

    @Override
    public BacteriaStats<?> stats() {
        return this.stats;
    }

    public static class Builder
    implements Bacteria.Builder<SimpleBacteria> {
        private LongRange initialSize = LongRange.of(0L, 0L);
        private Bacteria.Resource.ItemResource resource = new Bacteria.Resource.ItemResource(Items.AIR);
        private FloatRange growthRate = FloatRange.of(0.0f, 0.0f);
        private FloatRange mutationResistance = FloatRange.of(0.0f, 0.0f);
        private FloatRange productionRate = FloatRange.of(0.0f, 0.0f);
        private IntRange lifespan = IntRange.of(0, 0);
        private int color;

        public Builder initialSize(LongRange initialSize) {
            this.initialSize = initialSize;
            return this;
        }

        public Builder resource(Item resource) {
            this.resource = new Bacteria.Resource.ItemResource(resource);
            return this;
        }

        public Builder growthRate(FloatRange growthRate) {
            this.growthRate = growthRate;
            return this;
        }

        public Builder mutationResistance(FloatRange mutationResistance) {
            this.mutationResistance = mutationResistance;
            return this;
        }

        public Builder productionRate(FloatRange productionRate) {
            this.productionRate = productionRate;
            return this;
        }

        public Builder lifespan(IntRange lifespan) {
            this.lifespan = lifespan;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public SimpleBacteria build() {
            return new SimpleBacteria(this.initialSize, this.resource, new SimpleBacteriaStats(this.growthRate, this.mutationResistance, this.productionRate, this.lifespan, this.color));
        }
    }

    public static final class Serializer
    implements BacteriaSerializer<SimpleBacteria> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<SimpleBacteria> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LongRange.MAP_CODEC.fieldOf("initial_size").forGetter(SimpleBacteria::initialSize), (App)Bacteria.Resource.ItemResource.CODEC.fieldOf("bacteria").forGetter(SimpleBacteria::resource), (App)BacteriaStats.CODEC.fieldOf("stats").forGetter(SimpleBacteria::stats)).apply((Applicative)instance, SimpleBacteria::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SimpleBacteria> STREAM_CODEC = StreamCodec.composite(LongRange.STREAM_CODEC, SimpleBacteria::initialSize, Bacteria.Resource.ItemResource.STREAM_CODEC, SimpleBacteria::resource, BacteriaStats.STREAM_CODEC, SimpleBacteria::stats, SimpleBacteria::new);

        private Serializer() {
        }

        @Override
        public MapCodec<SimpleBacteria> mapCodec() {
            return MAP_CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SimpleBacteria> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

