/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blocks.AquaticCatalystBlock;
import com.portingdeadmods.nautec.content.recipes.AquaticCatalystChannelingRecipe;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.utils.SidedCapUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class AquaticCatalystBlockEntity
extends LaserBlockEntity {
    private RecipeHolder<AquaticCatalystChannelingRecipe> currentRecipe;
    private RecipeHolder<AquaticCatalystChannelingRecipe> nextRecipe;
    private int duration;
    private ResourceLocation currentRecipeId;
    private ResourceLocation nextRecipeId;

    public AquaticCatalystBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.AQUATIC_CATALYST.get(), blockPos, blockState);
        this.addItemHandler(1, (Integer slot, ItemStack stack) -> this.getRecipeForCache((ItemStack)stack) != null);
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.isActive()) {
            if (this.duration >= ((AquaticCatalystChannelingRecipe)this.currentRecipe.value()).duration()) {
                this.duration = 0;
                this.currentRecipe = null;
            } else {
                int distance = this.getLaserDistances().getInt((Object)((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
                if (distance > 0) {
                    int amount = ((AquaticCatalystChannelingRecipe)this.currentRecipe.value()).powerAmount() / ((AquaticCatalystChannelingRecipe)this.currentRecipe.value()).duration();
                    this.transmitPower(amount);
                    ++this.duration;
                }
            }
        } else {
            this.currentRecipe = this.nextRecipe;
            this.getItemHandler().extractItem(0, 1, false);
        }
    }

    public boolean isActive() {
        return this.currentRecipe != null;
    }

    public RecipeHolder<AquaticCatalystChannelingRecipe> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public int getRemainingDuration() {
        return this.currentRecipe != null ? ((AquaticCatalystChannelingRecipe)this.currentRecipe.value()).duration() - this.duration : 0;
    }

    public ItemStack getProcessingItem() {
        return this.getItemHandler().getStackInSlot(0);
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    protected void onItemsChanged(int slot) {
        super.onItemsChanged(slot);
        this.nextRecipe = this.getRecipeForCache(this.getItemHandler().getStackInSlot(0));
        this.setStage();
    }

    @Override
    protected void onLaserDistancesChanged(Direction direction, int prevDistance) {
        super.onLaserDistancesChanged(direction, prevDistance);
        this.nextRecipe = this.getRecipeForCache(this.getItemHandler().getStackInSlot(0));
    }

    public void setStage() {
        float i = (float)this.getItemHandler().getStackInSlot(0).getCount() / (float)this.getItemHandler().getSlotLimit(0);
        int stage = (int)(i * 8.0f);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)AquaticCatalystBlock.STAGE, (Comparable)Integer.valueOf(stage)));
    }

    public RecipeHolder<AquaticCatalystChannelingRecipe> getRecipeForCache(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)AquaticCatalystChannelingRecipe.Type.INSTANCE, (RecipeInput)new SingleRecipeInput(stack), this.level).orElse(null);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return Set.of();
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        if (this.isActive()) {
            return Set.of(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
        }
        return Collections.emptySet();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return SidedCapUtils.allInsert(0);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.duration = tag.getInt("duration");
        this.currentRecipeId = ResourceLocation.parse((String)tag.getString("current_recipe"));
        this.nextRecipeId = ResourceLocation.parse((String)tag.getString("next_recipe"));
    }

    public void onLoad() {
        super.onLoad();
        this.currentRecipe = this.loadRecipe(this.currentRecipeId);
        this.nextRecipe = this.loadRecipe(this.nextRecipeId);
    }

    private RecipeHolder<AquaticCatalystChannelingRecipe> loadRecipe(ResourceLocation location) {
        return this.level.getRecipeManager().byKey(location).orElse(null);
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putInt("duration", this.duration);
        if (this.currentRecipe != null) {
            tag.putString("current_recipe", this.currentRecipe.toString());
        }
        if (this.nextRecipe != null) {
            tag.putString("next_recipe", this.nextRecipe.toString());
        }
    }
}

