/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.bacteria.IBacteriaStorage;
import com.portingdeadmods.nautec.content.items.PetriDishItem;
import com.portingdeadmods.nautec.content.menus.BacterialAnalyzerMenu;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class BacterialAnalyzerBlockEntity
extends LaserBlockEntity
implements MenuProvider {
    public static final int MAX_PROGRESS = NTConfig.bacteriaAnalyzerCraftingSpeed;
    public static final int POWER_USAGE = NTConfig.bacteriaAnalyzerPowerUsage;
    private boolean hasRecipe;
    private int progress;

    public BacterialAnalyzerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.BACTERIAL_ANALYZER.get(), blockPos, blockState);
        this.addItemHandler(2, 1, (Integer slot, ItemStack stack) -> slot == 0 && stack.getItem() instanceof PetriDishItem);
    }

    @Override
    protected void onItemsChanged(int slot) {
        BacteriaInstance bacteria;
        super.onItemsChanged(slot);
        ItemStack stack = this.getItemHandler().getStackInSlot(0);
        ItemStack resultStack = this.getItemHandler().getStackInSlot(1);
        IBacteriaStorage iBacteriaStorage = (IBacteriaStorage)stack.getCapability(NTCapabilities.BacteriaStorage.ITEM);
        this.hasRecipe = iBacteriaStorage != null ? !(bacteria = iBacteriaStorage.getBacteria(0)).isEmpty() && !bacteria.isAnalyzed() && resultStack.isEmpty() : false;
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.hasRecipe) {
            if (this.getPower() >= POWER_USAGE) {
                if (this.progress >= MAX_PROGRESS) {
                    ItemStack extracted = this.getItemHandler().extractItem(0, 1, false);
                    ItemStack result = extracted.copy();
                    IBacteriaStorage storage = (IBacteriaStorage)result.getCapability(NTCapabilities.BacteriaStorage.ITEM);
                    storage.getBacteria(0).setAnalyzed(true);
                    this.forceInsertItem(1, result, false);
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object)Direction.DOWN);
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    public Component getDisplayName() {
        return Component.literal((String)"Bacterial Analyzer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new BacterialAnalyzerMenu(containerId, playerInventory, this);
    }
}

