/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyConverterBlockEntity
extends LaserBlockEntity
implements IEnergyStorage {
    private static final int FE_CONVERSION_RATE = 100;
    private int feStored = 0;
    private static final int MAX_FE = 100000;

    public EnergyConverterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.ENERGY_CONVERTER.get(), blockPos, blockState);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of();
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of((Object[])Direction.values());
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        if (!this.level.isClientSide) {
            Direction[] directions;
            for (Direction direction : directions = Direction.values()) {
                int energyToConvert;
                LaserBlockEntity laserBlockEntity;
                BlockPos pos = this.worldPosition.relative(direction);
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (!(blockEntity instanceof LaserBlockEntity) || !(laserBlockEntity = (LaserBlockEntity)blockEntity).getLaserInputs().contains(direction.getOpposite()) || (energyToConvert = Math.min(100, this.feStored)) <= 0) continue;
                this.transmitPower(energyToConvert);
                this.feStored -= energyToConvert;
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(100000 - this.feStored, maxReceive);
        if (!simulate) {
            this.feStored += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.feStored;
    }

    public int getMaxEnergyStored() {
        return 100000;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

