/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.controller;

import com.google.common.collect.ImmutableMap;
import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockEntity;
import com.portingdeadmods.nautec.api.multiblocks.MultiblockData;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.DrainPartBlock;
import com.portingdeadmods.nautec.content.multiblocks.DrainMultiblock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.utils.BlockUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends LaserBlockEntity
implements MultiblockEntity {
    private MultiblockData multiblockData;
    private float valveIndependentAngle;
    private float valveChasingVelocity;
    private int valveInUse;
    private int valveSpeed;
    private float lidIndependentAngle;
    private float lidChasingVelocity;
    private int lidInUse;
    private int lidSpeed;
    private boolean closing;
    private int valveLidInterval;

    public DrainBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.DRAIN.get(), blockPos, blockState);
        this.addFluidTank(NTConfig.drainCapacity);
        this.multiblockData = MultiblockData.EMPTY;
    }

    public void open() {
        this.valveInUse = 12;
        this.valveSpeed = 30;
        this.level.playSound(null, this.worldPosition, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.setOpen(true);
    }

    @Override
    public void onPowerChanged() {
        super.onPowerChanged();
        this.updatePowerAndBubbles();
    }

    public void close() {
        this.lidInUse = 36;
        this.lidSpeed = -6;
        this.closing = true;
    }

    public boolean isMoving() {
        return this.lidInUse > 0 || this.valveInUse > 0;
    }

    public boolean isClosing() {
        return this.closing;
    }

    private void setOpen(boolean value) {
        BlockPos[] aroundSelf;
        BlockPos selfPos = this.worldPosition;
        for (BlockPos blockPos : aroundSelf = BlockUtils.getBlocksAroundSelf3x3(selfPos)) {
            BlockState state = this.level.getBlockState(blockPos);
            if (!state.hasProperty((Property)DrainPartBlock.OPEN)) continue;
            this.level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)DrainPartBlock.OPEN, (Comparable)Boolean.valueOf(value)));
        }
        BlockState selfState = this.level.getBlockState(selfPos);
        if (selfState.hasProperty((Property)DrainPartBlock.OPEN)) {
            this.level.setBlockAndUpdate(selfPos, (BlockState)selfState.setValue((Property)DrainPartBlock.OPEN, (Comparable)Boolean.valueOf(value)));
        }
    }

    private boolean hasWater() {
        BlockPos[] aroundSelf;
        BlockPos selfPos = this.worldPosition.above();
        for (BlockPos blockPos : aroundSelf = BlockUtils.getBlocksAroundSelf3x3(selfPos)) {
            if (this.level.getBlockState(blockPos).getFluidState().is(FluidTags.WATER)) continue;
            return false;
        }
        return this.level.getBlockState(selfPos).getFluidState().is(FluidTags.WATER);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        if (((Boolean)this.getBlockState().getValue((Property)DrainMultiblock.FORMED)).booleanValue()) {
            return ObjectSet.of((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
        }
        return ObjectSet.of();
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.getPower() == 0 && ((Boolean)this.getBlockState().getValue((Property)DrainPartBlock.HAS_POWER)).booleanValue()) {
            this.updatePowerAndBubbles();
        }
        this.performRotation();
        this.performDraining();
    }

    private void updatePowerAndBubbles() {
        BlockPos[] aroundSelf = BlockUtils.getBlocksAroundSelfHorizontal(this.worldPosition);
        boolean hasPower = this.getPower() > 15;
        for (BlockPos pos : aroundSelf) {
            BlockState state = this.level.getBlockState(pos);
            if (!state.hasProperty((Property)DrainPartBlock.HAS_POWER)) continue;
            this.level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DrainPartBlock.HAS_POWER, (Comparable)Boolean.valueOf(hasPower)));
        }
        BlockState selfState = this.getBlockState();
        if (selfState.hasProperty((Property)DrainPartBlock.HAS_POWER)) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)selfState.setValue((Property)DrainPartBlock.HAS_POWER, (Comparable)Boolean.valueOf(hasPower)));
        }
        this.updateBubbleColumns();
    }

    private boolean openAndFormed() {
        BlockState blockState = this.getBlockState();
        return blockState.hasProperty((Property)DrainPartBlock.OPEN) && (Boolean)blockState.getValue((Property)DrainPartBlock.OPEN) != false && (Boolean)blockState.getValue((Property)DrainMultiblock.FORMED) != false;
    }

    private void performDraining() {
        if (this.level.getGameTime() % 20L == 0L && this.lidInUse == 0 && this.getPower() > NTConfig.drainPower && this.hasWater() && this.openAndFormed() && this.level.getBiome(this.worldPosition).is(BiomeTags.IS_OCEAN)) {
            this.getFluidHandler().fill(new FluidStack((Fluid)NTFluids.SALT_WATER.getStillFluid(), NTConfig.drainSaltWaterAmount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void performRotation() {
        float actualValveSpeed = this.getValveSpeed();
        this.valveChasingVelocity += (actualValveSpeed * 10.0f / 3.0f - this.valveChasingVelocity) * 0.25f;
        this.valveIndependentAngle += this.valveChasingVelocity;
        if (this.valveInUse > 0) {
            --this.valveInUse;
            if (this.valveInUse == 0) {
                this.valveSpeed = 0;
                if (!this.closing) {
                    this.valveLidInterval = 60;
                } else {
                    this.closing = false;
                    this.setOpen(false);
                }
            }
        }
        if (this.valveLidInterval > 0) {
            --this.valveLidInterval;
            if (this.valveLidInterval == 0) {
                if (!this.closing) {
                    this.lidInUse = 72;
                    this.lidSpeed = 3;
                } else {
                    this.valveInUse = 12;
                    this.valveSpeed = -30;
                }
            }
        }
        float actualLidSpeed = this.getLidSpeed();
        this.lidChasingVelocity += (actualLidSpeed * 10.0f / 3.0f - this.lidChasingVelocity) * 0.25f;
        this.lidIndependentAngle += this.lidChasingVelocity;
        if (this.lidInUse > 0) {
            --this.lidInUse;
            if (this.lidInUse == 0) {
                this.lidSpeed = 0;
                if (this.closing) {
                    this.valveLidInterval = 30;
                } else {
                    this.updateBubbleColumns();
                }
            }
        }
    }

    private void updateBubbleColumns() {
        if (this.getPower() > 15) {
            BlockPos[] aroundSelf;
            BlockPos selfPos = this.worldPosition;
            for (BlockPos blockPos : aroundSelf = BlockUtils.getBlocksAroundSelfHorizontal(selfPos)) {
                BlockState blockState = this.level.getBlockState(blockPos);
                BubbleColumnBlock.updateColumn((LevelAccessor)this.level, (BlockPos)blockPos.above(), (BlockState)blockState);
            }
            BubbleColumnBlock.updateColumn((LevelAccessor)this.level, (BlockPos)selfPos.above(), (BlockState)this.level.getBlockState(selfPos));
        }
    }

    private float getValveSpeed() {
        return this.valveSpeed;
    }

    public float getValveIndependentAngle(float partialTicks) {
        return (this.valveIndependentAngle + partialTicks * this.valveChasingVelocity) / 360.0f;
    }

    private float getLidSpeed() {
        return this.lidSpeed;
    }

    public float getLidIndependentAngle(float partialTicks) {
        return (this.lidIndependentAngle + partialTicks * this.lidChasingVelocity) / 360.0f;
    }

    public <T> ImmutableMap<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        if (capability == Capabilities.FluidHandler.BLOCK) {
            return ImmutableMap.of((Object)Direction.DOWN, (Object)Pair.of((Object)((Object)IOActions.EXTRACT), (Object)new int[]{0}));
        }
        return ImmutableMap.of();
    }

    @Override
    public MultiblockData getMultiblockData() {
        return this.multiblockData;
    }

    @Override
    public void setMultiblockData(MultiblockData data) {
        this.multiblockData = data;
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.put("multiblockData", (Tag)this.saveMBData());
        tag.putFloat("angle", this.lidIndependentAngle);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.multiblockData = this.loadMBData(tag.getCompound("multiblockData"));
        this.lidIndependentAngle = tag.getFloat("angle");
    }
}

