/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.part;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.blockentities.multiblock.MultiblockPartEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.multiblocks.BioReactorMultiblock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class BioReactorPartBlockEntity
extends LaserBlockEntity
implements MultiblockPartEntity {
    private final Set<Direction> laserInputs;
    private final Set<Direction> laserOutputs = Collections.emptySet();
    private final Map<Direction, Pair<IOActions, int[]>> sidedInteractions;
    private BlockPos controllerPos;

    public BioReactorPartBlockEntity(BlockPos pos, BlockState blockState) {
        super(NTBlockEntityTypes.BIO_REACTOR_PART.get(), pos, blockState);
        this.laserInputs = new HashSet<Direction>();
        this.sidedInteractions = Collections.emptyMap();
    }

    @Override
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Override
    public void setControllerPos(BlockPos blockPos) {
        this.controllerPos = blockPos;
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return this.laserInputs;
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return this.laserOutputs;
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return this.sidedInteractions;
    }

    public void setLaserInput(boolean hatch) {
        if (hatch) {
            this.laserInputs.add(Direction.UP);
        } else {
            this.laserInputs.remove(Direction.UP);
        }
    }

    @Override
    public void commonTick() {
        BlockEntity blockEntity;
        BlockPos controllerPos1;
        super.commonTick();
        if ((Integer)this.getBlockState().getValue((Property)BioReactorMultiblock.BIO_REACTOR_PART) % 2 != 0 && ((Boolean)this.getBlockState().getValue((Property)BioReactorMultiblock.TOP)).booleanValue() && this.laserInputs.size() == 1 && (controllerPos1 = this.getControllerPos()) != null && (blockEntity = this.level.getBlockEntity(controllerPos1)) instanceof LaserBlockEntity) {
            LaserBlockEntity laserBE = (LaserBlockEntity)blockEntity;
            BlockPos diff = controllerPos1.subtract((Vec3i)this.worldPosition);
            Direction dir = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ()).getOpposite();
            laserBE.receivePower(this.getPower(), dir, this.worldPosition);
            laserBE.receiveNewPurity(this.purity, dir, this.worldPosition);
        }
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.setLaserInput(tag.getBoolean("input"));
        if (tag.getBoolean("hasControllerPos")) {
            this.controllerPos = BlockPos.of((long)tag.getLong("controllerPos"));
        }
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putBoolean("input", this.laserInputs.size() == 1);
        tag.putBoolean("hasControllerPos", this.controllerPos != null);
        if (this.controllerPos != null) {
            tag.putLong("controllerPos", this.controllerPos.asLong());
        }
    }
}

