/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.semi;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.blockentities.multiblock.semi.PrismarineCrystalBlockEntity;
import com.portingdeadmods.nautec.content.blocks.multiblock.semi.PrismarineCrystalPartBlock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class PrismarineCrystalPartBlockEntity
extends LaserBlockEntity {
    public PrismarineCrystalPartBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.PRISMARINE_CRYSTAL_PART.get(), blockPos, blockState);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of();
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        if ((Integer)this.getBlockState().getValue((Property)PrismarineCrystalPartBlock.INDEX) == 0) {
            return ObjectSet.of((Object)Direction.UP);
        }
        if ((Integer)this.getBlockState().getValue((Property)PrismarineCrystalPartBlock.INDEX) == 5) {
            return ObjectSet.of((Object)Direction.DOWN);
        }
        return ObjectSet.of();
    }

    @Override
    public boolean shouldRender(Direction direction) {
        return this.getLaserOutputs().contains(direction) && this.power > 0;
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        PrismarineCrystalBlockEntity crystalBE = this.getCrystalBE();
        if (crystalBE != null) {
            if (this.canTransmitPower()) {
                this.transmitPower(crystalBE.getPower());
            }
            this.setPurity(3.0f);
        }
    }

    @Override
    protected void checkConnections() {
        block0: for (Direction direction : this.getLaserOutputs()) {
            int maxLaserDistance = this.getMaxLaserDistance();
            for (int i = 1; i < maxLaserDistance; ++i) {
                LaserBlockEntity laserBlockEntity;
                BlockPos pos = this.worldPosition.relative(direction, i);
                BlockState state = this.level.getBlockState(pos);
                BlockEntity blockEntity = this.level.getBlockEntity(pos);
                if (blockEntity instanceof LaserBlockEntity && (laserBlockEntity = (LaserBlockEntity)blockEntity).getLaserInputs().contains(direction.getOpposite())) {
                    this.laserDistances.put((Object)direction, i);
                    continue block0;
                }
                if (state.canBeReplaced() && i != maxLaserDistance - 1) continue;
                this.laserDistances.put((Object)direction, i);
                continue block0;
            }
        }
    }

    public PrismarineCrystalBlockEntity getCrystalBE() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.getCrystalPos());
        if (blockEntity instanceof PrismarineCrystalBlockEntity) {
            PrismarineCrystalBlockEntity be = (PrismarineCrystalBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    public BlockPos getCrystalPos() {
        int i = (Integer)this.getBlockState().getValue((Property)PrismarineCrystalPartBlock.INDEX);
        return this.worldPosition.above(i - 2);
    }

    private boolean canTransmitPower() {
        int i = (Integer)this.getBlockState().getValue((Property)PrismarineCrystalPartBlock.INDEX);
        return i == 0 || i == 5;
    }
}

