/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.content.blockentities.DecorativePrismarineCrystalBlockEntity;
import com.portingdeadmods.nautec.content.blocks.DecorativePrismarineCrystalPartBlock;
import com.portingdeadmods.nautec.registries.NTBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecorativePrismarineCrystalBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));

    public DecorativePrismarineCrystalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return DecorativePrismarineCrystalBlock.simpleCodec(DecorativePrismarineCrystalBlock::new);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DecorativePrismarineCrystalBlockEntity(pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        for (int i = 0; i < 6; ++i) {
            BlockPos curPos = pos.above(i);
            if (i == 0) {
                level.setBlockAndUpdate(curPos, ((DecorativePrismarineCrystalBlock)((Object)NTBlocks.DECORATIVE_PRISMARINE_CRYSTAL.get())).defaultBlockState());
                continue;
            }
            level.setBlockAndUpdate(curPos, (BlockState)((DecorativePrismarineCrystalPartBlock)((Object)NTBlocks.DECORATIVE_PRISMARINE_CRYSTAL_PART.get())).defaultBlockState().setValue((Property)DecorativePrismarineCrystalPartBlock.INDEX, (Comparable)Integer.valueOf(i)));
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        DecorativePrismarineCrystalBlock.removeCrystal(level, player, pos);
        return true;
    }

    public static void removeCrystal(Level level, Player player, BlockPos thisPos) {
        if (thisPos != null) {
            for (int i = 0; i < 6; ++i) {
                BlockPos curPos = thisPos.above(i);
                level.removeBlock(curPos, false);
            }
        }
    }
}

