/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items;

import com.portingdeadmods.nautec.data.NTDataComponentsUtils;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.Tooltips;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DivingSuitArmorItem
extends ArmorItem {
    public DivingSuitArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.stacksTo(1).durability(type.getDurability(20)));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        int currentOxygen;
        Player player;
        if (entity instanceof Player && DivingSuitArmorItem.hasFullArmorSet(stack, player = (Player)entity) && player.isUnderWater() && !player.isCreative() && !player.isSpectator() && level.getGameTime() % 20L == 0L && (currentOxygen = NTDataComponentsUtils.getOxygenLevels(stack).intValue()) > 0) {
            NTDataComponentsUtils.setOxygenLevels(stack, currentOxygen - 1);
            player.setAirSupply(player.getMaxAirSupply());
        }
    }

    private static boolean hasFullArmorSet(ItemStack stack, Player player) {
        return stack == player.getItemBySlot(EquipmentSlot.CHEST) && player.getItemBySlot(EquipmentSlot.HEAD).is(NTItems.DIVING_HELMET) && player.getItemBySlot(EquipmentSlot.LEGS).is(NTItems.DIVING_LEGGINGS) && player.getItemBySlot(EquipmentSlot.FEET).is(NTItems.DIVING_BOOTS);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.is((Item)NTItems.DIVING_HELMET.get())) {
            Tooltips.trans(tooltipComponents, "nautec.helm.desc", ChatFormatting.GRAY);
        }
        if (stack.is((Item)NTItems.DIVING_CHESTPLATE.get())) {
            int oxygen = NTDataComponentsUtils.getOxygenLevels(stack);
            int minutesRemaining = oxygen / 60;
            int secondsRemaining = oxygen % 60;
            int red = (int)(255.0 * (1.0 - (double)oxygen / 600.0));
            int green = (int)(255.0 * ((double)oxygen / 600.0));
            int colorHex = red << 16 | green << 8;
            tooltipComponents.add((Component)Component.literal((String)String.format("Oxygen: %d minutes %d seconds", minutesRemaining, secondsRemaining)).withStyle(style -> style.withColor(TextColor.fromRgb((int)colorHex))));
            tooltipComponents.add((Component)Component.literal((String)"Can be filled up using Bottles of pressurized air").withStyle(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return stack.is((Item)NTItems.DIVING_HELMET.get()) ? ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"textures/example/diving_suit.png") : super.getArmorTexture(stack, entity, slot, layer, innerModel);
    }
}

