/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record AquaticCatalystChannelingRecipe(Ingredient ingredient, int powerAmount, float purity, int duration) implements Recipe<SingleRecipeInput>
{
    public static final String NAME = "aquatic_catalyst_channeling";

    public boolean matches(@NotNull SingleRecipeInput recipeInput, @NotNull Level level) {
        return this.ingredient.test(recipeInput.item());
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient});
    }

    public static class Serializer
    implements RecipeSerializer<AquaticCatalystChannelingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<AquaticCatalystChannelingRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(AquaticCatalystChannelingRecipe::ingredient), (App)Codec.INT.fieldOf("power_amount").forGetter(AquaticCatalystChannelingRecipe::powerAmount), (App)Codec.FLOAT.fieldOf("purity").forGetter(AquaticCatalystChannelingRecipe::purity), (App)Codec.INT.fieldOf("duration").forGetter(AquaticCatalystChannelingRecipe::duration)).apply((Applicative)builder, AquaticCatalystChannelingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AquaticCatalystChannelingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AquaticCatalystChannelingRecipe::ingredient, (StreamCodec)ByteBufCodecs.INT, AquaticCatalystChannelingRecipe::powerAmount, (StreamCodec)ByteBufCodecs.FLOAT, AquaticCatalystChannelingRecipe::purity, (StreamCodec)ByteBufCodecs.INT, AquaticCatalystChannelingRecipe::duration, AquaticCatalystChannelingRecipe::new);

        private Serializer() {
        }

        @NotNull
        public MapCodec<AquaticCatalystChannelingRecipe> codec() {
            return MAP_CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, AquaticCatalystChannelingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<AquaticCatalystChannelingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }

        public String toString() {
            return AquaticCatalystChannelingRecipe.NAME;
        }
    }
}

