/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.data.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ComponentPowerStorage(int powerStored, int powerCapacity, float purity) {
    public static final ComponentPowerStorage EMPTY = new ComponentPowerStorage(0, 0, 0.0f);
    public static final Codec<ComponentPowerStorage> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("power_stored").forGetter(ComponentPowerStorage::powerStored), (App)Codec.INT.fieldOf("power_capacity").forGetter(ComponentPowerStorage::powerCapacity), (App)Codec.FLOAT.fieldOf("purity").forGetter(ComponentPowerStorage::purity)).apply((Applicative)builder, ComponentPowerStorage::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ComponentPowerStorage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ComponentPowerStorage::powerStored, (StreamCodec)ByteBufCodecs.INT, ComponentPowerStorage::powerCapacity, (StreamCodec)ByteBufCodecs.FLOAT, ComponentPowerStorage::purity, ComponentPowerStorage::new);

    public static ComponentPowerStorage withCapacity(int initialCapacity) {
        return new ComponentPowerStorage(0, initialCapacity, 0.0f);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentPowerStorage)) {
            return false;
        }
        ComponentPowerStorage that = (ComponentPowerStorage)o;
        return this.powerStored == that.powerStored && this.powerCapacity == that.powerCapacity && this.purity == that.purity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.powerStored, this.powerCapacity, Float.valueOf(this.purity));
    }
}

