/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.content.blocks.AquaticCatalystBlock;
import com.portingdeadmods.nautec.content.blocks.BacteriaPipeBlock;
import com.portingdeadmods.nautec.content.blocks.CrateBlock;
import com.portingdeadmods.nautec.content.blocks.LaserJunctionBlock;
import com.portingdeadmods.nautec.content.blocks.OilBarrelBlock;
import com.portingdeadmods.nautec.content.blocks.multiblock.controller.AugmentationStationBlock;
import com.portingdeadmods.nautec.datagen.MultiblockModelHelper;
import com.portingdeadmods.nautec.registries.NTBlocks;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.IntegerRange;

public class BlockModelProvider
extends BlockStateProvider {
    public BlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "nautec", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        MultiblockModelHelper helper = new MultiblockModelHelper(this);
        this.axisBlock((RotatedPillarBlock)NTBlocks.DARK_PRISMARINE_PILLAR.get());
        this.simpleBlock((Block)NTBlocks.CHISELED_DARK_PRISMARINE.get());
        this.simpleBlock((Block)NTBlocks.PRISMARINE_SAND.get());
        this.simpleBlock((Block)NTBlocks.POLISHED_PRISMARINE.get());
        this.simpleBlock((Block)NTBlocks.AQUARINE_STEEL_BLOCK.get());
        this.simpleBlock((Block)NTBlocks.CAST_IRON_BLOCK.get());
        this.simpleBlock((Block)NTBlocks.CREATIVE_POWER_SOURCE.get());
        this.aquaticCatalyst((AquaticCatalystBlock)NTBlocks.AQUATIC_CATALYST.get());
        this.existingFacingBlock((Block)NTBlocks.PRISMARINE_RELAY.get(), (Block)NTBlocks.PRISMARINE_RELAY.get());
        this.longDistanceLaser((Block)NTBlocks.LONG_DISTANCE_LASER.get());
        this.laserJunction((Block)NTBlocks.LASER_JUNCTION.get());
        this.simpleBlock((Block)NTBlocks.MIXER.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.MIXER.get())));
        this.simpleBlock((Block)NTBlocks.CHARGER.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.CHARGER.get())));
        this.simpleBlock((Block)NTBlocks.FISHING_STATION.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.FISHING_STATION.get())));
        this.crateBlock((CrateBlock)((Object)NTBlocks.CRATE.get()));
        this.rustyCrateBlock((CrateBlock)((Object)NTBlocks.RUSTY_CRATE.get()));
        this.simpleBlock((Block)NTBlocks.MUTATOR.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.MUTATOR.get())));
        this.simpleBlock((Block)NTBlocks.INCUBATOR.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.INCUBATOR.get())));
        helper.drainController((Block)NTBlocks.DRAIN.get());
        helper.drainPart((Block)NTBlocks.DRAIN_PART.get(), IntegerRange.of((int)0, (int)8));
        helper.augmentationStationController((AugmentationStationBlock)((Object)NTBlocks.AUGMENTATION_STATION.get()));
        helper.augmentationStationPart((Block)NTBlocks.AUGMENTATION_STATION_PART.get(), IntegerRange.of((int)0, (int)8));
        helper.augmentationStationExtension((Block)NTBlocks.AUGMENTATION_STATION_EXTENSION.get());
        helper.bioReactorPart((Block)NTBlocks.BIO_REACTOR_PART.get());
        this.simpleBlock((Block)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD.get());
        this.horizontalBlock((Block)NTBlocks.BIO_REACTOR.get(), (ModelFile)this.models().cubeTop(this.name((Block)NTBlocks.BIO_REACTOR.get()), this.blockTexture((Block)NTBlocks.POLISHED_PRISMARINE.get()), this.blockTexture((Block)NTBlocks.BIO_REACTOR.get(), "_top")));
        this.simpleBlock((Block)NTBlocks.DRAIN_WALL.get());
        this.simpleBlock((Block)NTBlocks.BROWN_POLYMER_BLOCK.get());
        this.oilBarrel((Block)NTBlocks.OIL_BARREL.get(), (ModelFile)this.models().cubeBottomTop(this.name((Block)NTBlocks.OIL_BARREL.get()), this.blockTexture((Block)NTBlocks.OIL_BARREL.get(), "_side"), this.blockTexture((Block)NTBlocks.OIL_BARREL.get(), "_bottom"), this.blockTexture((Block)NTBlocks.OIL_BARREL.get())), (ModelFile)this.models().cubeBottomTop(this.name((Block)NTBlocks.OIL_BARREL.get()) + "_open", this.blockTexture((Block)NTBlocks.OIL_BARREL.get(), "_side"), this.blockTexture((Block)NTBlocks.OIL_BARREL.get(), "_bottom"), this.blockTexture((Block)NTBlocks.OIL_BARREL.get(), "_open")));
        this.horizontalBlock((Block)NTBlocks.BACTERIAL_ANALYZER.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.BACTERIAL_ANALYZER.get())));
        this.horizontalBlock((Block)NTBlocks.BACTERIAL_ANALYZER_TOP.get(), (ModelFile)this.models().getExistingFile(this.existingModelFile((Block)NTBlocks.BACTERIAL_ANALYZER_TOP.get())));
    }

    private void aquaticCatalyst(AquaticCatalystBlock block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (Direction dir : Direction.values()) {
            Iterator iterator = AquaticCatalystBlock.STAGE.getPossibleValues().iterator();
            while (iterator.hasNext()) {
                int stage = (Integer)iterator.next();
                builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)dir).with((Property)AquaticCatalystBlock.STAGE, (Comparable)Integer.valueOf(stage)).modelForState().modelFile(this.createActiveACModel(block, stage)).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 180) % 360).addModel();
            }
        }
    }

    private void pipeBlock(Block block) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)block);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        this.pipeConnection(builder, loc, Direction.DOWN, 0, 0);
        this.pipeConnection(builder, loc, Direction.UP, 180, 0);
        this.pipeConnection(builder, loc, Direction.NORTH, 90, 180);
        this.pipeConnection(builder, loc, Direction.EAST, 90, 270);
        this.pipeConnection(builder, loc, Direction.SOUTH, 90, 0);
        this.pipeConnection(builder, loc, Direction.WEST, 90, 90);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.pipeBaseModel(loc)).addModel()).end();
    }

    private ModelFile pipeBaseModel(ResourceLocation blockLoc) {
        return ((BlockModelBuilder)this.models().withExistingParent(blockLoc.getPath() + "_base", this.modLoc("block/pipe_base"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)blockLoc.getNamespace(), (String)("block/" + blockLoc.getPath())));
    }

    private ModelFile pipeConnectionModel(ResourceLocation blockLoc) {
        return ((BlockModelBuilder)this.models().withExistingParent(blockLoc.getPath() + "_connection", this.modLoc("block/pipe_connection"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)blockLoc.getNamespace(), (String)("block/" + blockLoc.getPath())));
    }

    private void pipeConnection(MultiPartBlockStateBuilder builder, ResourceLocation loc, Direction direction, int x, int y) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(this.pipeConnectionModel(loc)).rotationX(x).rotationY(y).addModel()).condition((Property)BacteriaPipeBlock.CONNECTION[direction.get3DDataValue()], (Comparable[])new Boolean[]{true}).end();
    }

    private void laserJunction(Block block) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        this.laserJunctionConnection(builder, block, Direction.DOWN, 0, 0);
        this.laserJunctionConnection(builder, block, Direction.UP, 180, 0);
        this.laserJunctionConnection(builder, block, Direction.NORTH, 90, 180);
        this.laserJunctionConnection(builder, block, Direction.EAST, 90, 270);
        this.laserJunctionConnection(builder, block, Direction.SOUTH, 90, 0);
        this.laserJunctionConnection(builder, block, Direction.WEST, 90, 90);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile(block), "_base"))).addModel()).end();
    }

    private void laserJunctionConnection(MultiPartBlockStateBuilder builder, Block block, Direction direction, int x, int y) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile(block), "_connection_in"))).rotationX(x).rotationY(y).addModel()).condition(LaserJunctionBlock.CONNECTION[direction.ordinal()], (Comparable[])new LaserJunctionBlock.ConnectionType[]{LaserJunctionBlock.ConnectionType.INPUT}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile(block), "_connection_out"))).rotationX(x).rotationY(y).addModel()).condition(LaserJunctionBlock.CONNECTION[direction.ordinal()], (Comparable[])new LaserJunctionBlock.ConnectionType[]{LaserJunctionBlock.ConnectionType.OUTPUT}).end();
    }

    public void longDistanceLaser(Block block) {
        BlockModelBuilder modelBuilder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "cube")).texture("up", this.extend(this.blockTexture(block), "_top"))).texture("down", this.extend(this.blockTexture(block), "_bottom"))).texture("north", this.extend(this.blockTexture(block), "_side"))).texture("east", this.extend(this.blockTexture(block), "_side"))).texture("south", this.extend(this.blockTexture(block), "_side"))).texture("west", this.extend(this.blockTexture(block), "_side"));
        this.facingBlock(block, (ModelFile)modelBuilder);
    }

    public void existingFacingBlock(Block block, Block modelOf) {
        this.facingBlock(block, (ModelFile)this.models().getExistingFile(this.existingModelFile(modelOf)));
    }

    public void facingBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().modelFile(model).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile(model).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationX(90).rotationY(270).addModel();
    }

    public void oilBarrel(Block block, ModelFile model, ModelFile openModel) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).rotationX(90).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(openModel).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(openModel).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(openModel).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(openModel).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(openModel).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).with((Property)OilBarrelBlock.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(openModel).rotationX(90).rotationY(270).addModel();
    }

    private void crateBlock(CrateBlock crateBlock) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)crateBlock);
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.existingModelFile((Block)crateBlock))).addModel();
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.extend(this.existingModelFile((Block)crateBlock), "_open"))).addModel();
    }

    private void rustyCrateBlock(CrateBlock crateBlock) {
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)crateBlock);
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.rustedCrateModel(crateBlock, true)).addModel();
        builder.partialState().with((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.rustedCrateModel(crateBlock, false)).addModel();
    }

    private ModelFile rustedCrateModel(CrateBlock block, boolean open) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block) + (open ? "_open" : ""), this.extend(this.existingModelFile((Block)NTBlocks.CRATE.get()), open ? "_open" : ""))).texture("2", "nautec:block/crate/rusty_top_inner")).texture("4", "nautec:block/crate/rusty")).texture("5", "nautec:block/crate/rusty_top")).texture("particle", "nautec:block/crate/rusty");
    }

    public ResourceLocation multiblockTexture(Multiblock multiblock, String name) {
        return this.modLoc("block/multiblock/" + NTRegistries.MULTIBLOCK.getKey((Object)multiblock).getPath() + "/" + name);
    }

    private ModelFile createActiveACModel(AquaticCatalystBlock block, int stage) {
        return this.models().cube(this.name((Block)block) + (String)(stage != 0 ? "_" + stage : ""), this.blockTexture((Block)block, "_bottom"), this.extend(this.blockTexture((Block)block), "_top_" + stage), this.blockTexture((Block)block, "_side"), this.blockTexture((Block)block, "_side"), this.blockTexture((Block)block, "_side"), this.blockTexture((Block)block, "_side"));
    }

    public ResourceLocation blockTexture(Block block, String suffix) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + suffix));
    }

    public ResourceLocation existingModelFile(Block block) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath()));
    }

    public ResourceLocation existingModelFile(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public String name(Block block) {
        return this.key(block).getPath();
    }

    public ResourceLocation extend(ResourceLocation rl, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(rl.getPath() + suffix));
    }
}

