/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.network;

import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.bacteria.IBacteriaStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record BacteriaSlotClickedPayload(BlockPos pos, int slot, BacteriaInstance bacteria) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BacteriaSlotClickedPayload> TYPE = new CustomPacketPayload.Type(Nautec.rl("insert_bacteria"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BacteriaSlotClickedPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BacteriaSlotClickedPayload::pos, (StreamCodec)ByteBufCodecs.INT, BacteriaSlotClickedPayload::slot, BacteriaInstance.STREAM_CODEC, BacteriaSlotClickedPayload::bacteria, BacteriaSlotClickedPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            IBacteriaStorage itemBacteriaStorage = (IBacteriaStorage)player.containerMenu.getCarried().getCapability(NTCapabilities.BacteriaStorage.ITEM);
            BlockEntity patt0$temp = level.getBlockEntity(this.pos);
            if (patt0$temp instanceof ContainerBlockEntity) {
                ContainerBlockEntity be = (ContainerBlockEntity)patt0$temp;
                IBacteriaStorage beBacteriaStorage = be.getBacteriaStorage();
                if (itemBacteriaStorage.getBacteria(0).isEmpty() || BacteriaInstance.isSameBacteriaAndStats(itemBacteriaStorage.getBacteria(0), beBacteriaStorage.getBacteria(this.slot))) {
                    BacteriaInstance instance = beBacteriaStorage.getBacteria(this.slot).copy();
                    itemBacteriaStorage.setBacteria(0, instance);
                    itemBacteriaStorage.onBacteriaChanged(this.slot);
                    beBacteriaStorage.setBacteria(this.slot, BacteriaInstance.EMPTY.copy());
                    beBacteriaStorage.onBacteriaChanged(this.slot);
                } else {
                    beBacteriaStorage.insertBacteria(this.slot, this.bacteria, false);
                    itemBacteriaStorage.setBacteria(0, BacteriaInstance.EMPTY.copy());
                    itemBacteriaStorage.onBacteriaChanged(this.slot);
                }
            }
        }).exceptionally(err -> {
            Nautec.LOGGER.error("Error handling bacteria payload", err);
            return null;
        });
    }
}

