/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.network;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.data.NTDataAttachments;
import com.portingdeadmods.nautec.utils.AugmentClientHelper;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import com.portingdeadmods.nautec.utils.codec.AugmentCodecs;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ClearAugmentPayload(AugmentSlot augmentSlot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClearAugmentPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"clear_augment_payload"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClearAugmentPayload> STREAM_CODEC = StreamCodec.composite(AugmentCodecs.AUGMENT_SLOT_STREAM_CODEC, ClearAugmentPayload::augmentSlot, ClearAugmentPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void clearAugmentAction(ClearAugmentPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            AugmentSlot slot = payload.augmentSlot();
            HashMap<AugmentSlot, Augment> augments = new HashMap<AugmentSlot, Augment>(AugmentHelper.getAugments(player));
            HashMap<AugmentSlot, CompoundTag> augmentsData = new HashMap<AugmentSlot, CompoundTag>(AugmentHelper.getAugmentsData(player));
            augments.remove(slot);
            augmentsData.remove(slot);
            player.setData(NTDataAttachments.AUGMENTS, augments);
            player.setData(NTDataAttachments.AUGMENTS_EXTRA_DATA, augmentsData);
            if (player.level().isClientSide()) {
                AugmentClientHelper.invalidateCacheFor(player, slot);
            }
        });
    }
}

