/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.events.helper.AugmentLayerRenderer;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;

public final class AugmentClientHelper {
    public static void initCache(Player player) {
        Map<AugmentSlot, Augment> playerAugments = AugmentHelper.getAugments(player);
        HashMap<AugmentSlot, Augment> filteredAugments = new HashMap<AugmentSlot, Augment>();
        for (Map.Entry<AugmentSlot, Augment> entry : playerAugments.entrySet()) {
            if (entry.getValue() == null) continue;
            filteredAugments.put(entry.getKey(), entry.getValue());
        }
        AugmentLayerRenderer.AUGMENTS_CACHE = filteredAugments;
    }

    public static void invalidateCacheFor(Player player, AugmentSlot augmentSlot) {
        AugmentLayerRenderer.AUGMENTS_CACHE.remove(augmentSlot);
        Augment augment = AugmentHelper.getAugmentBySlot(player, augmentSlot);
        if (augment != null) {
            AugmentLayerRenderer.AUGMENTS_CACHE.put(augmentSlot, augment);
        }
    }
}

