/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.api.augments.AugmentType;
import com.portingdeadmods.nautec.data.NTDataAttachments;
import com.portingdeadmods.nautec.network.ClearAugmentPayload;
import com.portingdeadmods.nautec.utils.AugmentClientHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public final class AugmentHelper {
    public static Augment getAugmentBySlot(Player player, AugmentSlot augmentSlot) {
        return AugmentHelper.getAugments(player).get(augmentSlot);
    }

    public static Map<AugmentSlot, Augment> getAugments(Player player) {
        return (Map)player.getData(NTDataAttachments.AUGMENTS);
    }

    public static Map<AugmentSlot, CompoundTag> getAugmentsData(Player player) {
        return (Map)player.getData(NTDataAttachments.AUGMENTS_EXTRA_DATA);
    }

    public static void setAugment(Player player, AugmentSlot augmentSlot, Augment augment) {
        HashMap<AugmentSlot, Augment> augments = new HashMap<AugmentSlot, Augment>(AugmentHelper.getAugments(player));
        augments.put(augmentSlot, augment);
        player.setData(NTDataAttachments.AUGMENTS, augments);
    }

    public static void setAugmentExtraData(Player player, AugmentSlot augmentSlot, CompoundTag tag) {
        HashMap<AugmentSlot, CompoundTag> augments = new HashMap<AugmentSlot, CompoundTag>(AugmentHelper.getAugmentsData(player));
        augments.put(augmentSlot, tag);
        player.setData(NTDataAttachments.AUGMENTS_EXTRA_DATA, augments);
    }

    public static Augment createAugment(AugmentType<?> augmentType, Player player, AugmentSlot augmentSlot) {
        Object augment = augmentType.create(augmentSlot);
        ((Augment)augment).setPlayer(player);
        ((Augment)augment).onAdded(player);
        AugmentHelper.setAugment(player, augmentSlot, augment);
        if (player.level().isClientSide()) {
            AugmentClientHelper.invalidateCacheFor(player, augmentSlot);
        }
        return augment;
    }

    public static void removeAugment(Player player, AugmentSlot augmentSlot) {
        Augment augment = AugmentHelper.getAugmentBySlot(player, augmentSlot);
        if (augment != null) {
            augment.onRemoved(player);
        }
        HashMap<AugmentSlot, Augment> augments = new HashMap<AugmentSlot, Augment>(AugmentHelper.getAugments(player));
        HashMap<AugmentSlot, CompoundTag> augmentsData = new HashMap<AugmentSlot, CompoundTag>(AugmentHelper.getAugmentsData(player));
        augments.remove(augmentSlot);
        augmentsData.remove(augmentSlot);
        player.setData(NTDataAttachments.AUGMENTS, augments);
        player.setData(NTDataAttachments.AUGMENTS_EXTRA_DATA, augmentsData);
        if (!player.level().isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClearAugmentPayload(augmentSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (player.level().isClientSide()) {
            AugmentClientHelper.invalidateCacheFor(player, augmentSlot);
        }
    }
}

