/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.portingdeadmods.nautec.NTRegistries;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.bacteria.CollapsedBacteriaStats;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.components.ComponentBacteriaStorage;
import com.portingdeadmods.nautec.registries.NTItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class BacteriaHelper {
    public static Bacteria getBacteria(HolderLookup.Provider lookup, ResourceKey<Bacteria> bacteriaType) {
        Optional lookup1 = lookup.asGetterLookup().lookup(NTRegistries.BACTERIA_KEY);
        return lookup1.map(bacteriaHolderGetter -> (Bacteria)bacteriaHolderGetter.getOrThrow(bacteriaType).value()).orElse(null);
    }

    public static List<Bacteria> getBacteriaList(HolderLookup.Provider lookup) {
        return ((HolderLookup.RegistryLookup)lookup.lookup(NTRegistries.BACTERIA_KEY).get()).listElements().map(Holder.Reference::value).toList();
    }

    public static List<ResourceKey<Bacteria>> getBacteriaKeys(HolderLookup.Provider lookup) {
        return ((HolderLookup.RegistryLookup)lookup.lookup(NTRegistries.BACTERIA_KEY).get()).listElementIds().toList();
    }

    public static ItemStack getMaxStatDish(ResourceKey<Bacteria> bac, HolderLookup.Provider lookup) {
        Bacteria bacteria = BacteriaHelper.getBacteria(lookup, bac);
        ItemStack dish = new ItemStack((ItemLike)NTItems.PETRI_DISH.get());
        if (bacteria == null) {
            return dish;
        }
        dish.set(NTDataComponents.BACTERIA, (Object)new ComponentBacteriaStorage(new BacteriaInstance(bac, bacteria.maxInitialSize(), (CollapsedBacteriaStats)bacteria.stats().collapseMaxStats(), true)));
        return dish;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Component resourceTooltip(ResourceKey<Bacteria> key) {
        Item item2;
        Bacteria bacteria = BacteriaHelper.getBacteria((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), key);
        MutableComponent component = Component.literal((String)"  Resource: ").withStyle(ChatFormatting.YELLOW);
        Bacteria.Resource resource = bacteria.resource();
        if (!(resource instanceof Bacteria.Resource.ItemResource)) return component;
        Bacteria.Resource.ItemResource itemResource = (Bacteria.Resource.ItemResource)resource;
        try {
            Item item;
            item2 = item = itemResource.item();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        component.append((Component)item2.getName(ItemStack.EMPTY).copy().withStyle(ChatFormatting.WHITE));
        return component;
    }
}

