/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public final class ItemUtils {
    public static final int ITEM_POWER_INPUT = 128;
    public static final int POWER_BAR_COLOR = FastColor.ARGB32.color((int)94, (int)133, (int)164);

    public static int powerForDurabilityBar(ItemStack itemStack) {
        IPowerStorage powerStorage = (IPowerStorage)itemStack.getCapability(NTCapabilities.PowerStorage.ITEM);
        if (powerStorage != null) {
            int powerStored = powerStorage.getPowerStored();
            int powerCapacity = powerStorage.getPowerCapacity();
            float chargeRatio = (float)powerStored / (float)powerCapacity;
            return Math.round(13.0f - (1.0f - chargeRatio) * 13.0f);
        }
        return 0;
    }

    public static void giveItemToPlayerNoSound(Player player, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        int preferredSlot = -1;
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.getInventory());
        Level level = player.level();
        ItemStack remainder = stack;
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (!remainder.isEmpty()) {
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)remainder, (boolean)false);
        }
        if (!remainder.isEmpty() && !level.isClientSide) {
            ItemEntity entityitem = new ItemEntity(level, player.getX(), player.getY() + 0.5, player.getZ(), remainder);
            entityitem.setPickUpDelay(40);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            level.addFreshEntity((Entity)entityitem);
        }
    }
}

