/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public final class ParticleUtils {
    private static final int PARTICLE_COUNT = 20;
    private static final double PARTICLE_RADIUS = 0.5;
    private static final int PARTICLE_DELAY = 5;
    private static int particleTicks = 0;

    public static void spawnParticlesAroundItem(ItemEntity itemEntity, Level level, ParticleOptions particlesTypes) {
        assert (level.isClientSide);
        if (particleTicks % 5 == 0) {
            for (int i = 0; i < 20; ++i) {
                double theta = level.random.nextDouble() * Math.PI * 2.0;
                double phi = level.random.nextDouble() * Math.PI;
                double xOffset = 0.5 * Math.sin(phi) * Math.cos(theta);
                double yOffset = 0.5 * Math.cos(phi);
                double zOffset = 0.5 * Math.sin(phi) * Math.sin(theta);
                level.addParticle(particlesTypes, itemEntity.getX() + xOffset, itemEntity.getY() + yOffset, itemEntity.getZ() + zOffset, 0.0, 0.0, 0.0);
            }
        }
        ++particleTicks;
    }

    public static void spawnParticlesAroundBlock(BlockPos blockPos, Level level, ParticleOptions particlesTypes) {
        assert (level.isClientSide);
        if (particleTicks % 5 == 0) {
            for (int i = 0; i < 20; ++i) {
                double theta = level.random.nextDouble() * Math.PI * 2.0;
                double phi = level.random.nextDouble() * Math.PI;
                double xOffset = 0.5 * Math.sin(phi) * Math.cos(theta);
                double yOffset = 0.5 * Math.cos(phi);
                double zOffset = 0.5 * Math.sin(phi) * Math.sin(theta);
                level.addParticle(particlesTypes, (double)blockPos.getX() + 0.5 + xOffset, (double)blockPos.getY() + 0.5 + yOffset, (double)blockPos.getZ() + 0.5 + zOffset, 0.0, 0.0, 0.0);
            }
        }
        ++particleTicks;
    }

    public static void spawnBreakParticle(BlockPos pos, Block block, int count) {
        assert (Minecraft.getInstance().level != null && Minecraft.getInstance().level.isClientSide);
        for (int i = 0; i < count; ++i) {
            Minecraft.getInstance().particleEngine.add((Particle)new TerrainParticle(Minecraft.getInstance().level, (double)((float)pos.getX() + 0.5f), (double)pos.above().getY(), (double)((float)pos.getZ() + 0.5f), 0.0 + (double)i / 10.0, 0.0 + (double)i / 10.0, 0.0 + (double)i / 10.0, block.defaultBlockState()));
        }
    }
}

