/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.sugar.impl.handlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import nolijium.mixinextras.injector.wrapoperation.WrapOperation;
import nolijium.mixinextras.service.MixinExtrasService;
import nolijium.mixinextras.sugar.impl.SugarParameter;
import nolijium.mixinextras.sugar.impl.handlers.HandlerInfo;
import nolijium.mixinextras.sugar.impl.handlers.HandlerTransformer;
import nolijium.mixinextras.sugar.impl.ref.LocalRefUtils;
import nolijium.mixinextras.utils.ASMUtils;
import nolijium.mixinextras.wrapper.factory.FactoryRedirectWrapper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;

class LocalHandlerTransformer
extends HandlerTransformer {
    private static final Set TARGET_INJECTORS = new HashSet<String>(Arrays.asList(Type.getDescriptor(ModifyConstant.class), Type.getDescriptor(Redirect.class), Type.getDescriptor(FactoryRedirectWrapper.class)));

    LocalHandlerTransformer(IMixinInfo iMixinInfo, SugarParameter sugarParameter) {
        super(iMixinInfo, sugarParameter);
    }

    @Override
    public boolean isRequired(MethodNode methodNode) {
        return (methodNode = InjectionInfo.getInjectorAnnotation((IMixinInfo)this.mixin, (MethodNode)methodNode)) != null && TARGET_INJECTORS.contains(methodNode.desc) && LocalRefUtils.getTargetType(this.parameter.type, this.parameter.genericType) == this.parameter.type;
    }

    @Override
    public void transform(HandlerInfo handlerInfo) {
        Type type = Type.getType((Class)LocalRefUtils.getInterfaceFor(this.parameter.type));
        handlerInfo.wrapParameter(this.parameter, type, ASMUtils.isPrimitive(this.parameter.type) ? null : this.parameter.type, (insnList, runnable) -> LocalRefUtils.generateUnwrapping(insnList, this.parameter.type, runnable));
    }

    static {
        for (String string : MixinExtrasService.getInstance().getAllClassNames(WrapOperation.class.getName())) {
            TARGET_INJECTORS.add("L" + string.replace('.', '/') + ';');
        }
    }
}

