/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.utils;

import java.util.List;
import java.util.Map;
import nolijium.mixinextras.utils.MixinExtrasLogger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

public class InjectorUtils {
    private static final MixinExtrasLogger LOGGER = MixinExtrasLogger.get("InjectorUtils");

    public static boolean isVirtualRedirect(InjectionNodes.InjectionNode injectionNode) {
        return injectionNode.isReplaced() && injectionNode.hasDecoration("redirector") && injectionNode.getCurrentTarget().getOpcode() != 184;
    }

    public static boolean isDynamicInstanceofRedirect(InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getOriginalTarget();
        injectionNode = injectionNode.getCurrentTarget();
        return abstractInsnNode.getOpcode() == 193 && injectionNode instanceof MethodInsnNode && Type.getReturnType((String)((MethodInsnNode)injectionNode).desc).equals(Type.getType(Class.class));
    }

    public static void checkForDupedNews(Map object) {
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            for (InjectionNodes.InjectionNode injectionNode : (List)((Map.Entry)object.next()).getValue()) {
                AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
                if (abstractInsnNode.getOpcode() != 187 || abstractInsnNode.getNext().getOpcode() != 89) continue;
                injectionNode.decorate("mixinextras_newIsDuped", (Object)Boolean.TRUE);
            }
        }
    }

    public static boolean isDupedNew(InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
        return abstractInsnNode != null && abstractInsnNode.getOpcode() == 187 && injectionNode.hasDecoration("mixinextras_newIsDuped");
    }

    public static boolean isDupedFactoryRedirect(InjectionNodes.InjectionNode injectionNode) {
        AbstractInsnNode abstractInsnNode = injectionNode.getOriginalTarget();
        return injectionNode.isReplaced() && abstractInsnNode.getOpcode() == 187 && !injectionNode.hasDecoration("mixinextras_wrappedOperation") && injectionNode.hasDecoration("mixinextras_newIsDuped");
    }

    public static AbstractInsnNode findFactoryRedirectThrowString(Target object, AbstractInsnNode abstractInsnNode) {
        object = ((Target)object).insns.iterator(object.indexOf(abstractInsnNode));
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)object.next();
            if (!(abstractInsnNode2 instanceof LdcInsnNode)) continue;
            abstractInsnNode2 = (LdcInsnNode)abstractInsnNode2;
            if (!(abstractInsnNode2.cst instanceof String) || !((String)abstractInsnNode2.cst).startsWith("@Redirect constructor handler ")) continue;
            return abstractInsnNode2;
        }
        LOGGER.warn("Please inform LlamaLad7! Failed to find factory redirect throw string for {}", Bytecode.describeNode((AbstractInsnNode)abstractInsnNode));
        return null;
    }

    public static void checkForImmediatePops(Map object) {
        object = object.values().iterator();
        while (object.hasNext()) {
            for (InjectionNodes.InjectionNode injectionNode : (List)object.next()) {
                AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
                if (!(abstractInsnNode instanceof MethodInsnNode) || !InjectorUtils.isTypePoppedByInstruction(Type.getReturnType((String)((MethodInsnNode)abstractInsnNode).desc), abstractInsnNode.getNext())) continue;
                injectionNode.decorate("mixinextras_operationIsImmediatelyPopped", (Object)Boolean.TRUE);
            }
        }
    }

    private static boolean isTypePoppedByInstruction(Type type, AbstractInsnNode abstractInsnNode) {
        switch (type.getSize()) {
            case 2: {
                return abstractInsnNode.getOpcode() == 88;
            }
            case 1: {
                return abstractInsnNode.getOpcode() == 87;
            }
        }
        return false;
    }
}

